package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import com.google.zxing.client.result.ISBNParsedResult;
import net.doo.snap.lib.R;

/**
 * Handles books encoded by their ISBN values.
 */
public final class ISBNResultHandler extends ResultHandler {
    private static final int[] buttons = {
            R.string.button_product_search,
            R.string.button_book_search
    };
    private static final int OPEN_PRODUCT_SEARCH = 0;
    private static final int OPEN_BOOK_SEARCH = 1;

    public ISBNResultHandler(Activity activity, ISBNParsedResult result) {
        super(activity, result);
    }

    @Override
    public ISBNParsedResult getResult() {
        return (ISBNParsedResult) super.getResult();
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        ISBNParsedResult isbnResult = getResult();
        switch (index) {
            case OPEN_PRODUCT_SEARCH:
                openProductSearch(isbnResult.getISBN());
                break;
            case OPEN_BOOK_SEARCH:
                openBookSearch(isbnResult.getISBN());
                break;
        }
    }

    @Override
    public String getDisplayTitle() {
        return getResult().getISBN();
    }

    @Override
    public String getDisplaySubtitle() {
        return null;
    }

    @Override
    public String getDisplayText() {
        return null;
    }

    @Override
    public int getDisplayIconRes() {
        return R.drawable.ui_qr_ico_barcode;
    }
}
