/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.commonsware.cwac.camera.CameraFragment;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapFragment;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.inject.Inject;
import com.google.zxing.Result;
import com.google.zxing.client.result.GeoParsedResult;
import com.google.zxing.client.result.ParsedResultType;
import net.doo.snap.lib.snap.camera.barcode.BarcodeDetector;
import net.doo.snap.lib.snap.camera.barcode.result.ResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.ResultHandlerFactory;
import net.doo.snap.lib.snap.util.OrientationLocker;
import net.doo.snap.lib.ui.widget.text.CustomTypefaceTextView;
import roboguice.activity.RoboFragmentActivity;

public class BarcodeActivity
extends RoboFragmentActivity {
    private static final int DEFAULT_MAP_ZOOM = 15;
    @Inject
    private BarcodeDetector barcodeDetector;
    @Inject
    private Context context;
    @Inject
    private OrientationLocker orientationLocker;
    private ImageView codeTypeImage;
    private Result lastCodeResult;
    private TextView title;
    private TextView subTitle;
    private TextView contentText;
    private LinearLayout buttonsContainer;
    private ResultHandler barcodeHandler;
    private WebView webContainer;
    private View contentContainer;
    private GoogleMap map;
    private View mapContainer;
    private CameraFragment cameraFragment;

    public void onBackPressed() {
        if (this.barcodeHandler.getResult().getType() == ParsedResultType.URI && this.webContainer.canGoBack()) {
            this.webContainer.goBack();
        } else {
            this.overridePendingTransition(0, 0);
            super.onBackPressed();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903043);
        this.lastCodeResult = this.barcodeDetector.getLastResult();
        if (this.lastCodeResult == null) {
            this.finish();
            return;
        }
        this.barcodeHandler = ResultHandlerFactory.makeResultHandler((Activity)this, this.lastCodeResult);
        this.getActionBar().setTitle((CharSequence)this.context.getString(2131230804));
        this.getActionBar().setHomeButtonEnabled(true);
        this.getActionBar().setDisplayHomeAsUpEnabled(true);
        this.codeTypeImage = (ImageView)this.findViewById(2131165201);
        this.title = (TextView)this.findViewById(2131165204);
        this.subTitle = (TextView)this.findViewById(2131165205);
        this.contentText = (TextView)this.findViewById(2131165206);
        this.contentContainer = this.findViewById(2131165202);
        this.buttonsContainer = (LinearLayout)this.findViewById(2131165203);
        this.webContainer = (WebView)this.findViewById(2131165207);
        this.mapContainer = this.findViewById(2131165208);
        this.cameraFragment = (CameraFragment)this.getSupportFragmentManager().findFragmentById(0x7F07000F);
        MapFragment mapFragment = (MapFragment)this.getFragmentManager().findFragmentById(2131165208);
        mapFragment.getView().setVisibility(8);
        this.map = mapFragment.getMap();
        this.initContent();
        this.initActionButton();
    }

    private void initContent() {
        String displayTitle = this.barcodeHandler.getDisplayTitle();
        this.title.setVisibility(TextUtils.isEmpty((CharSequence)displayTitle) ? 8 : 0);
        this.title.setText((CharSequence)displayTitle);
        String displaySubtitle = this.barcodeHandler.getDisplaySubtitle();
        this.subTitle.setVisibility(TextUtils.isEmpty((CharSequence)displaySubtitle) ? 8 : 0);
        this.subTitle.setText((CharSequence)displaySubtitle);
        String displayText = this.barcodeHandler.getDisplayText();
        this.contentText.setVisibility(TextUtils.isEmpty((CharSequence)displayText) ? 8 : 0);
        this.contentText.setText((CharSequence)displayText);
        this.codeTypeImage.setImageResource(this.barcodeHandler.getDisplayIconRes());
        switch (this.barcodeHandler.getResult().getType()) {
            case ADDRESSBOOK: 
            case EMAIL_ADDRESS: 
            case PRODUCT: 
            case WIFI: 
            case TEL: 
            case SMS: 
            case CALENDAR: 
            case ISBN: {
                break;
            }
            case URI: {
                this.hideCamera();
                this.contentContainer.setVisibility(8);
                this.codeTypeImage.setVisibility(8);
                this.webContainer.setVisibility(0);
                this.buttonsContainer.setBackgroundColor(this.getResources().getColor(2131099681));
                this.webContainer.getSettings().setJavaScriptEnabled(true);
                this.webContainer.setWebViewClient(new WebViewClient());
                this.webContainer.loadUrl(this.barcodeHandler.getDisplayTitle());
                break;
            }
            case GEO: {
                if (this.map == null) break;
                this.hideCamera();
                this.contentContainer.setVisibility(8);
                this.codeTypeImage.setVisibility(8);
                this.buttonsContainer.setBackgroundColor(this.getResources().getColor(2131099681));
                this.mapContainer.setVisibility(0);
                GeoParsedResult geoResult = (GeoParsedResult)this.barcodeHandler.getResult();
                LatLng position = new LatLng(geoResult.getLatitude(), geoResult.getLongitude());
                this.map.addMarker(new MarkerOptions().position(position));
                this.map.moveCamera(CameraUpdateFactory.newLatLngZoom((LatLng)position, (float)15.0f));
                break;
            }
            default: {
                this.codeTypeImage.setVisibility(8);
                this.contentText.setGravity(3);
                this.contentText.setTextSize(0, (float)this.getResources().getDimensionPixelSize(2131361808));
            }
        }
    }

    private void hideCamera() {
        this.getSupportFragmentManager().beginTransaction().remove((Fragment)this.cameraFragment);
        this.findViewById(2131165200).setVisibility(8);
    }

    private void initActionButton() {
        this.buttonsContainer.setVisibility(this.barcodeHandler.getButtonCount() > 0 ? 0 : 8);
        int index = 0;
        while (index < this.barcodeHandler.getButtonCount()) {
            CustomTypefaceTextView button = (CustomTypefaceTextView)this.getLayoutInflater().inflate(2130903044, null);
            button.setText(this.barcodeHandler.getButtonText(index));
            final int finalIndex = index++;
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BarcodeActivity.this.barcodeHandler.handleButtonPress(finalIndex);
                }
            });
            this.buttonsContainer.addView((View)button);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131623936, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 2131165248) {
            ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
            ClipData clip = ClipData.newPlainText((CharSequence)"", (CharSequence)this.barcodeHandler.getResult().getDisplayResult());
            clipboard.setPrimaryClip(clip);
            Toast.makeText((Context)this, (CharSequence)this.getString(2131230811), (int)0).show();
            return true;
        }
        if (item.getItemId() == 2131165249) {
            Intent sharingIntent = new Intent("android.intent.action.SEND");
            sharingIntent.setType("text/plain");
            sharingIntent.putExtra("android.intent.extra.TEXT", this.barcodeHandler.getResult().getDisplayResult());
            this.startActivity(Intent.createChooser((Intent)sharingIntent, (CharSequence)this.getString(2131230809)));
            return true;
        }
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}

