/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.widget.Toast;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtils {
    private static final String FILE_NAME_EXCEPTIONS_REGULAR_EXPRESSION = "[\\\\|?*<\\\">+\\[\\]/':]";
    private static final Pattern FILE_NAME_ANTIPATTERN = Pattern.compile("[\\\\|?*<\\\">+\\[\\]/':]", 2);

    public static boolean isFileNameSafe(CharSequence name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        Matcher matcher = FILE_NAME_ANTIPATTERN.matcher(name);
        return !matcher.find();
    }

    public static File getExternalFilesDirOrShowError(Context context, String directoryName) throws IOException {
        File externalFilesDir = context.getExternalFilesDir(null);
        if (externalFilesDir == null) {
            return FileUtils.failAndShowErrorMessage(context);
        }
        File result = new File(externalFilesDir, directoryName);
        if (!result.exists() && !result.mkdir()) {
            return FileUtils.failAndShowErrorMessage(context);
        }
        return result;
    }

    private static File failAndShowErrorMessage(final Context context) throws IOException {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            public void run() {
                Toast.makeText((Context)context, (CharSequence)context.getString(2131230763), (int)1).show();
            }
        });
        throw new IOException("can't get external directory");
    }
}

