/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.preview;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.google.inject.Inject;
import java.io.IOException;
import java.lang.ref.WeakReference;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.PageStoreStrategy;
import net.doo.snap.lib.persistence.PictureProcessor;
import net.doo.snap.lib.persistence.RotationType;
import net.doo.snap.lib.snap.edit.EditLock;
import net.doo.snap.lib.snap.edit.events.DeletePageEvent;
import net.doo.snap.lib.snap.event.PageOptimizationTypeChangedEvent;
import net.doo.snap.lib.snap.preview.zoom.ZoomingManager;
import net.doo.snap.lib.ui.events.OnPageLongPressedEvent;
import net.doo.snap.lib.ui.util.SwipeDownTouchListener;
import net.doo.snap.lib.ui.util.TransformableDrawable;
import net.doo.snap.lib.ui.util.ViewUtils;
import net.doo.snap.lib.util.State;
import net.doo.snap.lib.util.StateHolder;
import net.doo.snap.lib.util.bitmap.BitmapLruCache;
import net.doo.snap.lib.util.bitmap.PageBitmapLoader;
import net.doo.snap.lib.util.log.DebugLog;
import net.doo.snap.lib.util.ui.CompositeTouchListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import roboguice.activity.event.OnActivityResultEvent;
import roboguice.event.EventManager;
import roboguice.event.Observes;
import roboguice.fragment.RoboFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagePreviewFragment
extends RoboFragment
implements LoaderManager.LoaderCallbacks<Bitmap> {
    private static final long DROPDOWN_ANIMATION_DURATION_MILLIS = 300L;
    private static final String PAGE_DATA = "PAGE_DATA";
    private static final float DROP_TARGET_INITIAL_SCALE_X = 0.8f;
    private static final float DROP_TARGET_INITIAL_SCALE_Y = 0.5f;
    private static final String PAGE_PATH = "PAGE_PATH";
    public static final String PLAY_DROP_IN_ANIMATION = "PLAY_DROP_IN_ANIMATION";
    public static final String DROP_X = "DROP_X";
    public static final String DROP_Y = "DROP_Y";
    public static final String PRESERVED_BITMAP = "PRESERVED_BITMAP";
    private ImageView thumbnail;
    private Bitmap bitmap;
    private View leftDropTarget;
    private View rightDropTarget;
    private View progressView;
    @Inject
    private EventManager eventManager;
    @Inject
    private PageStoreStrategy pageStoreStrategy;
    @Inject
    private BitmapLruCache bitmapLruCache;
    @Inject
    private EditLock editLock;
    @Inject
    private ZoomingManager zoomingManager;
    private float dropdownTargetWidth;
    private Page page;
    private boolean useDropInAnimation;
    private float dropX;
    private float dropY;
    private boolean selected = false;
    private State SHOW_LEFT_DROP_TARGET = new State(){

        public void onEnter() {
            ImagePreviewFragment.this.offsetThumbnail(ImagePreviewFragment.this.dropdownTargetWidth);
            ImagePreviewFragment.this.showDropTargetWithAnimation(ImagePreviewFragment.this.leftDropTarget);
        }

        public void onLeave() {
            ImagePreviewFragment.this.offsetThumbnail(0.0f);
            ImagePreviewFragment.this.leftDropTarget.animate().alpha(0.0f).start();
        }
    };
    private State SHOW_RIGHT_DROP_TARGET = new State(){

        public void onEnter() {
            ImagePreviewFragment.this.offsetThumbnail(-ImagePreviewFragment.this.dropdownTargetWidth);
            ImagePreviewFragment.this.showDropTargetWithAnimation(ImagePreviewFragment.this.rightDropTarget);
        }

        public void onLeave() {
            ImagePreviewFragment.this.offsetThumbnail(0.0f);
            ImagePreviewFragment.this.rightDropTarget.animate().alpha(0.0f).start();
        }
    };
    private StateHolder stateHolder = new StateHolder();
    @Nullable
    private TransformableDrawable transformableDrawable;

    public static ImagePreviewFragment newInstance(Page page) {
        Bundle pageParams = page.getParameters();
        ImagePreviewFragment fragment = new ImagePreviewFragment(pageParams.getBoolean(PLAY_DROP_IN_ANIMATION), pageParams.getFloat(DROP_X), pageParams.getFloat(DROP_Y), (Bitmap)pageParams.getParcelable(PRESERVED_BITMAP));
        pageParams.remove(PRESERVED_BITMAP);
        pageParams.remove(DROP_X);
        pageParams.remove(DROP_Y);
        pageParams.remove(PLAY_DROP_IN_ANIMATION);
        Bundle args = new Bundle();
        args.putParcelable(PAGE_DATA, (Parcelable)page);
        fragment.setArguments(args);
        return fragment;
    }

    public ImagePreviewFragment() {
    }

    @SuppressLint(value={"ValidFragment"})
    public ImagePreviewFragment(boolean useDropInAnimation, float dropX, float dropY, Bitmap preservedBitmap) {
        this.useDropInAnimation = useDropInAnimation;
        this.dropX = dropX;
        this.dropY = dropY;
        this.bitmap = preservedBitmap;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        Bundle args = this.getArguments();
        this.page = (Page)args.getParcelable(PAGE_DATA);
        Resources resources = activity.getResources();
        this.dropdownTargetWidth = resources.getDimension(2131361795);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            Bundle args = new Bundle();
            args.putString(PAGE_PATH, this.page.getFilePath(this.pageStoreStrategy, Page.ImageType.OPTIMIZED_PREVIEW));
            this.getLoaderManager().initLoader(0, args, (LoaderManager.LoaderCallbacks)this);
        }
        catch (IOException e) {
            DebugLog.logException(e);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(2130903054, null);
        this.restoreState(savedInstanceState);
        this.progressView = view.findViewById(2131165232);
        this.thumbnail = (ImageView)view.findViewById(2131165231);
        if (this.bitmap == null) {
            this.thumbnail.setImageDrawable(this.getPagePlaceholder());
            this.progressView.setVisibility(0);
        } else {
            this.thumbnail.setImageBitmap(this.bitmap);
            this.progressView.setVisibility(8);
        }
        this.leftDropTarget = view.findViewById(2131165229);
        this.rightDropTarget = view.findViewById(2131165230);
        this.zoomingManager.init((View)this.thumbnail, new ZoomingManager.ZoomingCallbacks(){

            @NotNull
            public Drawable getZoomedDrawable() {
                if (ImagePreviewFragment.this.transformableDrawable == null) {
                    throw new NullPointerException("Drawable is null");
                }
                TransformableDrawable drawable2 = new TransformableDrawable((Drawable)new BitmapDrawable(ImagePreviewFragment.this.getResources(), ImagePreviewFragment.this.bitmap));
                drawable2.setRotation(ImagePreviewFragment.this.transformableDrawable.getRotation());
                drawable2.setScale(ImagePreviewFragment.this.transformableDrawable.getScale());
                drawable2.setAdjustBounds(true);
                return drawable2;
            }

            public Object getToken() {
                return ImagePreviewFragment.this.page;
            }

            public boolean isZoomingEnabled() {
                return ImagePreviewFragment.this.selected && ImagePreviewFragment.this.bitmap != null && ImagePreviewFragment.this.transformableDrawable != null;
            }
        });
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(PAGE_DATA, (Parcelable)this.page);
    }

    private void restoreState(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        this.page = (Page)savedInstanceState.getParcelable(PAGE_DATA);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        SwipeDownTouchListener swipeDownTouchListener = new SwipeDownTouchListener(view){

            protected boolean onSwipeDownDetected() {
                if (!ImagePreviewFragment.this.editLock.isEditLocked()) {
                    ImagePreviewFragment.this.eventManager.fire((Object)new DeletePageEvent());
                    return true;
                }
                return false;
            }
        };
        view.setOnTouchListener((View.OnTouchListener)new CompositeTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                return !ImagePreviewFragment.this.selected || super.onTouch(view, event);
            }
        }.addGestureDetector(new GestureDetector((Context)this.getActivity(), (GestureDetector.OnGestureListener)new GestureListener())).addScaleGestureDetector(this.zoomingManager.buildScaleDetector()).addGestureDetector(this.zoomingManager.buildDobuleTapDetector()).addListener(swipeDownTouchListener));
        this.leftDropTarget.setAlpha(0.0f);
        this.rightDropTarget.setAlpha(0.0f);
        if (this.useDropInAnimation) {
            this.thumbnail.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean onPreDraw() {
                    try {
                        ImagePreviewFragment.this.playDropInAnimation();
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        ImagePreviewFragment.this.thumbnail.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    }
                }
            });
        }
    }

    private void playDropInAnimation() {
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        View rootView = this.getView();
        rootView.setTranslationX(this.dropX - (float)displayMetrics.widthPixels / 2.0f);
        rootView.setTranslationY(this.dropY - (float)rootView.getHeight() / 2.0f);
        rootView.setScaleX(0.5f);
        rootView.setScaleY(0.5f);
        rootView.setAlpha(0.5f);
        rootView.animate().scaleX(1.0f).scaleY(1.0f).translationX(0.0f).translationY(0.0f).alpha(1.0f).start();
        this.useDropInAnimation = false;
    }

    public void showLeftDropTarget() {
        this.stateHolder.updateState(this.SHOW_LEFT_DROP_TARGET);
    }

    public void showRightDropTarget() {
        this.stateHolder.updateState(this.SHOW_RIGHT_DROP_TARGET);
    }

    public void hideDropTarget() {
        this.stateHolder.updateState(State.DEFAULT);
    }

    private void offsetThumbnail(float offset) {
        this.thumbnail.animate().translationX(offset).setDuration(300L).setListener(null).start();
    }

    private void showDropTargetWithAnimation(View dropTarget) {
        dropTarget.setScaleX(0.8f);
        dropTarget.setScaleY(0.5f);
        dropTarget.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).start();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setPageRotation(RotationType rotationType) {
        Drawable drawable2 = this.thumbnail.getDrawable();
        if (drawable2 instanceof TransformableDrawable) {
            float scale = ViewUtils.fitBitmapToView(this.bitmap, (View)this.thumbnail, rotationType.getDegrees());
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)drawable2, (String)"scale", (float[])new float[]{scale}), ObjectAnimator.ofFloat((Object)drawable2, (String)"rotation", (float[])new float[]{this.calculateRotationAngle(rotationType)})});
            animatorSet.start();
        }
        this.page.setRotationType(rotationType);
    }

    private float calculateRotationAngle(RotationType rotationType) {
        if (this.page.getRotationType() == RotationType.ROTATION_360 && rotationType == RotationType.ROTATION_90 && this.thumbnail.getDrawable() instanceof TransformableDrawable) {
            ((TransformableDrawable)this.thumbnail.getDrawable()).setRotation(0.0f);
        }
        return rotationType.getDegrees();
    }

    public Page getPage() {
        return this.page;
    }

    private void initThumbnailParams() {
        Drawable drawable2 = this.thumbnail.getDrawable();
        if (!(drawable2 instanceof TransformableDrawable)) {
            return;
        }
        RotationType rotationType = this.page.getRotationType();
        float scale = ViewUtils.fitBitmapToView(this.bitmap, (View)this.thumbnail, rotationType.getDegrees());
        TransformableDrawable transformableDrawable = (TransformableDrawable)drawable2;
        transformableDrawable.setScale(scale);
        transformableDrawable.setRotation(this.calculateRotationAngle(this.page.getRotationType()));
        transformableDrawable.setAdjustBounds(true);
    }

    public Loader<Bitmap> onCreateLoader(int id2, Bundle args) {
        String path = args.getString(PAGE_PATH);
        return new PageBitmapLoader((Context)this.getActivity(), path, this.bitmapLruCache, this.bitmap);
    }

    public void onLoadFinished(Loader<Bitmap> loader, Bitmap data) {
        if (!this.isAdded()) {
            return;
        }
        this.bitmap = data;
        this.onDataReady();
    }

    private void onDataReady() {
        this.transformableDrawable = new TransformableDrawable((Drawable)new BitmapDrawable(this.getResources(), this.bitmap));
        this.thumbnail.setImageDrawable((Drawable)this.transformableDrawable);
        ViewUtils.postOnPreDraw((View)this.thumbnail, new Runnable(){

            public void run() {
                ImagePreviewFragment.this.initThumbnailParams();
            }
        });
        this.progressView.setVisibility(8);
    }

    public void onLoaderReset(Loader<Bitmap> loader) {
        this.bitmap = null;
        this.transformableDrawable = null;
        this.thumbnail.setImageDrawable(this.getPagePlaceholder());
        this.progressView.setVisibility(0);
    }

    private Drawable getPagePlaceholder() {
        ShapeDrawable drawable2 = new ShapeDrawable((Shape)new RectShape());
        drawable2.setPadding(new Rect());
        Paint paint = drawable2.getPaint();
        paint.setColor(this.getResources().getColor(2131099664));
        paint.setStyle(Paint.Style.FILL);
        Point imageSize = this.page.getImageSize(Page.ImageType.OPTIMIZED_PREVIEW);
        drawable2.setIntrinsicWidth(imageSize.x);
        drawable2.setIntrinsicHeight(imageSize.y);
        return drawable2;
    }

    private void editPolygonFinished(@Observes OnActivityResultEvent event) {
        Page resultPage;
        if (event.getResultCode() == -1 && event.getRequestCode() == 18 && this.page.equals(resultPage = (Page)event.getData().getParcelableExtra("page"))) {
            this.restartLoader();
        }
    }

    public void onOptimizationTypeChanged(@Observes PageOptimizationTypeChangedEvent event) {
        if (!this.page.equals(event.getPage())) {
            return;
        }
        try {
            this.bitmapLruCache.remove(this.page.getFilePath(this.pageStoreStrategy, Page.ImageType.OPTIMIZED_PREVIEW));
        }
        catch (IOException e) {
            DebugLog.logException(e);
        }
        this.page.setOptimizationType(event.getOptimizationType());
        new GenerateOptimizedPreviewTask(this.page, this.editLock, this.pageStoreStrategy, this.progressView).execute(new Void[0]);
    }

    private void restartLoader() {
        try {
            String path = this.page.getFilePath(this.pageStoreStrategy, Page.ImageType.OPTIMIZED_PREVIEW);
            Bundle args = new Bundle();
            args.putString(PAGE_PATH, path);
            this.bitmapLruCache.remove(path);
            this.bitmap = null;
            this.getLoaderManager().restartLoader(0, args, (LoaderManager.LoaderCallbacks)this);
        }
        catch (IOException e) {
            DebugLog.logException(e);
        }
    }

    public void onPause() {
        super.onPause();
        this.editLock.unlockEdit();
    }

    public void onDestroy() {
        this.eventManager.unregisterObserver((Object)this, PageOptimizationTypeChangedEvent.class);
        this.eventManager.unregisterObserver((Object)this, OnActivityResultEvent.class);
        super.onDestroy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenerateOptimizedPreviewTask
    extends AsyncTask<Void, Void, Void> {
        private Page page;
        private EditLock editLock;
        private PageStoreStrategy pageStoreStrategy;
        private WeakReference<View> progressViewReference;

        private GenerateOptimizedPreviewTask(Page page, EditLock editLock, PageStoreStrategy pageStoreStrategy, View progressView) {
            this.page = page;
            this.progressViewReference = new WeakReference<View>(progressView);
            this.editLock = editLock;
            this.pageStoreStrategy = pageStoreStrategy;
        }

        protected void onPreExecute() {
            this.editLock.lockEdit();
            View progressView = (View)this.progressViewReference.get();
            if (progressView != null) {
                progressView.setVisibility(0);
            }
        }

        protected Void doInBackground(Void ... voids) {
            try {
                PictureProcessor.generateOptimizedPreview(this.pageStoreStrategy, this.page, new ContourDetector());
            }
            catch (IOException e) {
                DebugLog.logException(e);
            }
            return null;
        }

        protected void onPostExecute(Void result) {
            this.editLock.unlockEdit();
            View progressView = (View)this.progressViewReference.get();
            if (progressView != null) {
                progressView.setVisibility(8);
            }
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public void onLongPress(MotionEvent motionEvent) {
            if (!ImagePreviewFragment.this.stateHolder.getCurrentState().equals(State.DEFAULT)) {
                return;
            }
            ImagePreviewFragment.this.eventManager.fire((Object)new OnPageLongPressedEvent(motionEvent.getX() - (float)ImagePreviewFragment.this.thumbnail.getLeft(), motionEvent.getY() - (float)ImagePreviewFragment.this.thumbnail.getTop(), (View)ImagePreviewFragment.this.thumbnail, ImagePreviewFragment.this.page, ImagePreviewFragment.this, ImagePreviewFragment.this.bitmap));
        }
    }
}

