/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import com.android.mms.exif.ExifInterface;
import com.commonsware.cwac.camera.PictureTransaction;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageCleanupTask
extends Thread {
    private byte[] data;
    private int cameraId;
    private PictureTransaction xact = null;
    private boolean applyMatrix = true;

    ImageCleanupTask(Context ctxt, byte[] data, int cameraId, PictureTransaction xact) {
        this.data = data;
        this.cameraId = cameraId;
        this.xact = xact;
        float heapPct = (float)data.length / (float)ImageCleanupTask.calculateHeapSize(ctxt);
        this.applyMatrix = heapPct < xact.host.maxPictureCleanupHeapUsage();
    }

    public void run() {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.cameraId, (Camera.CameraInfo)info);
        Matrix matrix = null;
        Bitmap cleaned = null;
        ExifInterface exif = null;
        int imageOrientation = 0;
        if (this.applyMatrix) {
            if (info.facing == 1) {
                if (this.xact.host.getDeviceProfile().portraitFFCFlipped() && (this.xact.displayOrientation == 90 || this.xact.displayOrientation == 270)) {
                    matrix = this.flip(new Matrix());
                } else if (this.xact.mirrorFFC()) {
                    matrix = this.mirror(new Matrix());
                }
            }
            try {
                if (this.xact.host.getDeviceProfile().useDeviceOrientation()) {
                    imageOrientation = this.xact.displayOrientation;
                } else {
                    exif = new ExifInterface();
                    exif.readExif(this.data);
                    Integer exifOrientation = exif.getTagIntValue(ExifInterface.TAG_ORIENTATION);
                    if (exifOrientation != null) {
                        if (exifOrientation == 6) {
                            imageOrientation = 90;
                        } else if (exifOrientation == 8) {
                            imageOrientation = 270;
                        } else if (exifOrientation == 3) {
                            imageOrientation = 180;
                        } else if (exifOrientation == 1) {
                            imageOrientation = 0;
                        }
                    }
                }
                if (imageOrientation != 0) {
                    matrix = this.rotate(matrix == null ? new Matrix() : matrix, imageOrientation);
                }
            }
            catch (IOException e) {
                Log.e((String)"CWAC-Camera", (String)"Exception parsing JPEG", (Throwable)e);
            }
            if (matrix != null && this.xact.needBitmap) {
                Bitmap original = BitmapFactory.decodeByteArray((byte[])this.data, (int)0, (int)this.data.length);
                cleaned = Bitmap.createBitmap((Bitmap)original, (int)0, (int)0, (int)original.getWidth(), (int)original.getHeight(), (Matrix)matrix, (boolean)true);
                original.recycle();
            }
        }
        if (this.xact.needBitmap) {
            if (cleaned == null) {
                cleaned = BitmapFactory.decodeByteArray((byte[])this.data, (int)0, (int)this.data.length);
            }
            this.xact.host.saveImage(this.xact, cleaned);
        }
        if (this.xact.needByteArray) {
            if (cleaned != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                cleaned.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
                this.data = out.toByteArray();
                try {
                    out.close();
                }
                catch (IOException e) {
                    Log.e((String)"CWAC-Camera", (String)"Exception in closing a BAOS???", (Throwable)e);
                }
            }
            this.xact.host.saveImage(this.xact, this.data, imageOrientation);
        }
        System.gc();
    }

    private Matrix mirror(Matrix input) {
        float[] mirrorY = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        Matrix matrixMirrorY = new Matrix();
        matrixMirrorY.setValues(mirrorY);
        input.postConcat(matrixMirrorY);
        return input;
    }

    private Matrix flip(Matrix input) {
        float[] mirrorY = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        Matrix matrixMirrorY = new Matrix();
        matrixMirrorY.setValues(mirrorY);
        input.preScale(1.0f, -1.0f);
        input.postConcat(matrixMirrorY);
        return input;
    }

    private Matrix rotate(Matrix input, int degree) {
        input.setRotate((float)degree);
        return input;
    }

    @TargetApi(value=11)
    private static int calculateHeapSize(Context ctxt) {
        ActivityManager am = (ActivityManager)ctxt.getSystemService("activity");
        int memoryClass = am.getMemoryClass();
        if (Build.VERSION.SDK_INT >= 11 && (ctxt.getApplicationInfo().flags & 0x100000) != 0) {
            memoryClass = am.getLargeMemoryClass();
        }
        return memoryClass * 0x100000;
    }
}

