package net.doo.snap.lib.ui.widget.text;

import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;

/**
 * Applies a {@link android.graphics.Typeface} to text
 */
public class CustomTypefaceSpan extends MetricAffectingSpan {

    private final Typeface typeface;

    public CustomTypefaceSpan(Typeface typeface) {
        this.typeface = typeface;
    }

    @Override
    public void updateMeasureState(TextPaint textPaint) {
        applyTypeface(textPaint);
    }

    @Override
    public void updateDrawState(TextPaint textPaint) {
        applyTypeface(textPaint);
    }

    private void applyTypeface(TextPaint textPaint) {
        textPaint.setTypeface(typeface);
    }

}
