package net.doo.snap.lib.util;

/**
 * Model for abstract state, in which component can enter to and respectively leave from.
 * Default implementation does nothing.
 */
public class State {

    /**
     * Default state, which does nothing. Added for convenience and readability.
     */
    public static final State DEFAULT = new State();

    private State referencedState;

    /**
     * Invoked when component enters to state
     */
    public void onEnter() {
    }

    /**
     * Invoked when component leaves state
     */
    public void onLeave() {
    }

    /**
     * Indicates that provided {@link net.doo.snap.lib.util.State} should be used next instead of current state.
     */
    protected void jumpToState(State state) {
        this.referencedState = state;
    }

    /**
     * @return if current {@link net.doo.snap.lib.util.State} referenced another state as a jump target,
     * then returns referenced {@link net.doo.snap.lib.util.State} and clears information about it. {@code null}
     * if there is no referenced state.
     */
    State takeReferencedState() {
        State state = referencedState;
        referencedState = null;

        return state;
    }

}
