/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.widget.text.processor;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.style.DynamicDrawableSpan;
import net.doo.snap.lib.ui.widget.text.processor.TextProcessor;

public class BulletProcessStrategy
implements TextProcessor.ProcessStrategy {
    private static final char DASH_CHARACTER = '-';
    private static final int STATE_DEFAULT = 0;
    private static final int STATE_FIRST_DASH = 1;
    private final Drawable bullet;
    private int state = 0;

    public BulletProcessStrategy(Drawable bullet) {
        this.bullet = bullet;
    }

    public boolean processChar(char character, SpannableStringBuilder output) {
        if (character != '-') {
            if (this.state == 1) {
                output.append('-');
            }
            this.state = 0;
            return false;
        }
        if (this.state == 0) {
            this.state = 1;
            return true;
        }
        if (this.state == 1) {
            if (output.length() > 0) {
                output.append('\n');
            }
            output.append(' ');
            output.setSpan((Object)new BulletSpan(this.bullet), output.length() - 1, output.length(), 33);
            output.append(' ');
            this.state = 0;
            return true;
        }
        return false;
    }

    public void reset() {
        this.state = 0;
    }

    private static class BulletSpan
    extends DynamicDrawableSpan {
        private final Drawable drawable;

        private BulletSpan(Drawable drawable2) {
            super(1);
            this.drawable = drawable2;
        }

        public Drawable getDrawable() {
            this.drawable.setBounds(0, 0, this.drawable.getIntrinsicWidth(), this.drawable.getIntrinsicHeight());
            return this.drawable;
        }

        public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
            canvas.save();
            canvas.translate(x, (float)(y - this.drawable.getIntrinsicHeight()) + (paint.descent() - paint.getTextSize() + (float)this.drawable.getIntrinsicHeight()) / 3.0f);
            this.drawable.draw(canvas);
            canvas.restore();
        }
    }
}

