package net.doo.snap.lib.snap.camera;

import android.content.Intent;
import android.os.Bundle;
import com.google.inject.Inject;
import net.doo.snap.lib.R;
import net.doo.snap.lib.analytics.ActivityAnalytics;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.PictureProcessor;
import net.doo.snap.lib.snap.event.PictureTakenEvent;
import net.doo.snap.lib.snap.util.OrientationLocker;
import net.doo.snap.lib.ui.util.ViewUtils;
import net.doo.snap.lib.util.log.DebugLog;
import roboguice.activity.RoboFragmentActivity;
import roboguice.event.Observes;

import java.io.IOException;

/**
 * Contains {@link CameraPreviewFragment}. Unlike {@link net.doo.snap.lib.snap.SnappingActivity} doesn't
 * provide any way to preview snapped documents and, instead, serves as creator of new pages.
 * Returns generated {@link net.doo.snap.lib.persistence.Page} as a result
 */
public class CameraActivity extends RoboFragmentActivity {

    public static final String PAGE_POSITION = "PAGE_POSITION";
    public static final String RESULT_PAGE = "RESULT_PAGE";

    @Inject
    private PictureProcessor pictureProcessor;
    @Inject
    private ActivityAnalytics activityAnalytics;
    @Inject
    private OrientationLocker orientationLocker;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.camera_activity);

        final CameraPreviewFragment cameraPreviewFragment = (CameraPreviewFragment) getSupportFragmentManager().findFragmentById(R.id.camera);

        ViewUtils.postOnPreDraw(findViewById(R.id.camera), new Runnable() {
            @Override
            public void run() {
                cameraPreviewFragment.setPreviewMode(false);
            }
        });
    }

    @SuppressWarnings("unused")
    public void onPictureTaken(@Observes PictureTakenEvent event) {
        Page page = null;
        try {
            page = pictureProcessor.processBytes(event.getImage(), event.getImageOrientation());
        } catch (IOException e) {
            DebugLog.logException(e);
        } finally {
            deliverResult(page);
        }
    }

    private void deliverResult(final Page page) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (page != null) {
                        Intent intent = new Intent();

                        intent.putExtra(RESULT_PAGE, page);
                        intent.putExtra(PAGE_POSITION, getIntent().getIntExtra(PAGE_POSITION, 0));
                        setResult(RESULT_OK, intent);
                    }
                } finally {
                    finish();
                }
            }
        });
    }

}
