package net.doo.snap.lib.snap.event;

/**
 * Fired when status of picture processing has changed.
 */
public class PictureProcessingStatusChangedEvent {

    private final boolean processing;

    public PictureProcessingStatusChangedEvent(boolean processing) {
        this.processing = processing;
    }

    /**
     * @return {@code true} if taken picture currently being processed. {@code false} otherwise.
     */
    public boolean isProcessing() {
        return processing;
    }

}
