package net.doo.snap.lib.snap.event;

/**
 * Fired when picture was taken
 */
public class PictureTakenEvent {

    private final byte[] image;
    private final int imageOrientation;

    public PictureTakenEvent(byte[] image, int imageOrientation) {
        this.image = image;
        this.imageOrientation = imageOrientation;
    }

    /**
     * @return byte array with image data
     */
    public byte[] getImage() {
        return image;
    }

    /**
     * @return image orientation in degrees
     */
    public int getImageOrientation() {
        return imageOrientation;
    }
}
