/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera;

import android.graphics.PointF;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.google.zxing.Result;
import java.util.List;
import net.doo.snap.lib.detector.CameraDetectorListener;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.snap.camera.barcode.BarcodeDetector;
import net.doo.snap.lib.util.log.DebugLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectionTask
implements Runnable {
    private final BarcodeDetector barcodeDetector;
    private ContourDetector detector;
    private final byte[] image;
    private final int previewWidth;
    private final int previewHeight;
    private final CameraDetectorListener listener;

    public DetectionTask(BarcodeDetector barcodeDetector, ContourDetector detector, byte[] image, int previewWidth, int previewHeight, CameraDetectorListener listener) {
        this.barcodeDetector = barcodeDetector;
        this.detector = detector;
        this.image = image;
        this.previewWidth = previewWidth;
        this.previewHeight = previewHeight;
        this.listener = listener;
    }

    @Override
    public void run() {
        DetectionResult detectionResult = this.detector.detect(this.image, this.previewWidth, this.previewHeight);
        List<PointF> polygon = this.detector.getPolygonF();
        DebugLog.d("CAMERA_PREVIEW", detectionResult.name());
        DebugLog.d("CAMERA_PREVIEW", TextUtils.join((CharSequence)";", polygon));
        this.detectBarcode(this.image, this.previewWidth, this.previewHeight);
        this.notifyCameraDetectorListener(detectionResult, polygon, null);
    }

    private void detectBarcode(byte[] data, int width, int height) {
        Result rawResult = this.barcodeDetector.decodeWithState(data, width, height);
        if (rawResult != null) {
            this.notifyCameraDetectorListener(DetectionResult.OK_BARCODE, null, rawResult.getText());
        }
    }

    private void notifyCameraDetectorListener(final DetectionResult detectionResult, final List<PointF> polygon, final String content) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            public void run() {
                switch (detectionResult) {
                    case OK: {
                        DetectionTask.this.listener.onDetectionOK(polygon);
                        return;
                    }
                    case OK_BUT_BAD_ANGLES: 
                    case OK_BUT_BAD_ASPECT_RATIO: 
                    case OK_BUT_TOO_SMALL: {
                        DetectionTask.this.listener.onDetectionWithError(detectionResult, polygon);
                        return;
                    }
                    case OK_BARCODE: {
                        DetectionTask.this.listener.onBarcodeDetectionOK(content);
                        return;
                    }
                    case ERROR_NOTHING_DETECTED: 
                    case ERROR_TOO_NOISY: 
                    case ERROR_TOO_DARK: {
                        DetectionTask.this.listener.onDetectionFailed(detectionResult);
                        return;
                    }
                }
            }
        });
    }
}

