package net.doo.snap.lib.snap.edit;

import android.os.Looper;

/**
 * Provides information about whether any page edition process currently running or not.
 * Not thread safe, all methods should be invoked from the main thread.
 */
public class EditLock {

    private boolean locked = false;

    /**
     * @return {@code true} if page edition is currently running and therefore no new edit operations
     * can be performed. {@code false} if it's possible to perform edit.
     */
    public boolean isEditLocked() {
        return locked;
    }

    /**
     * Moves {@link net.doo.snap.lib.snap.edit.EditLock} to the locked state, so no new edit operations
     * can be started.
     */
    public void lockEdit() {
        checkForMainLooper();
        locked = true;
    }

    /**
     * Moves {@link net.doo.snap.lib.snap.edit.EditLock} to the unlocked state, so edit operations
     * can perform normally.
     */
    public void unlockEdit() {
        checkForMainLooper();
        locked = false;
    }

    private void checkForMainLooper() throws IllegalStateException {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("Method should be called from the main thread");
        }
    }
}
