/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.sensor;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.FloatMath;
import com.google.inject.Inject;
import java.util.ArrayList;
import net.doo.snap.lib.sensor.SignificantMoveListener;
import roboguice.activity.event.OnPauseEvent;
import roboguice.activity.event.OnResumeEvent;
import roboguice.event.Observes;

public class SensorHelper
implements SensorEventListener {
    private SensorManager sensorManager;
    private Sensor accelerometer;
    private float[] gravity;
    private float acceleration;
    private float currentAcceleration;
    private float lastAcceleration;
    private ArrayList<SignificantMoveListener> listeners = new ArrayList();

    @Inject
    public SensorHelper(SensorManager sensorManager) {
        this.sensorManager = sensorManager;
        this.accelerometer = sensorManager.getDefaultSensor(1);
        this.acceleration = 0.0f;
        this.currentAcceleration = 9.80665f;
        this.lastAcceleration = 9.80665f;
    }

    private void registerListener() {
        if (this.accelerometer != null) {
            this.sensorManager.registerListener((SensorEventListener)this, this.accelerometer, 2);
        }
    }

    private void unregisterListener() {
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    private void onActivityResume(@Observes OnResumeEvent event) {
        if (!this.listeners.isEmpty()) {
            this.registerListener();
        }
    }

    private void onActivityPause(@Observes OnPauseEvent event) {
        this.unregisterListener();
    }

    public void registerSignificantMoveListener(SignificantMoveListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
            if (this.listeners.size() == 1) {
                this.registerListener();
            }
        }
    }

    public void unregisterSignificantMoveListener(SignificantMoveListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.unregisterListener();
        }
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 1) {
            this.gravity = (float[])event.values.clone();
            float x = this.gravity[0];
            float y = this.gravity[1];
            float z = this.gravity[2];
            this.lastAcceleration = this.currentAcceleration;
            this.currentAcceleration = FloatMath.sqrt((float)(x * x + y * y + z * z));
            float delta = this.currentAcceleration - this.lastAcceleration;
            this.acceleration = this.acceleration * 0.9f + delta;
            for (SignificantMoveListener listener : this.listeners) {
                listener.getSignificantMoveThreshold();
                if (!(this.acceleration > listener.getSignificantMoveThreshold())) continue;
                listener.onSignificantMove();
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

