/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaActionSound;
import android.media.MediaRecorder;
import android.media.MediaScannerConnection;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.CameraUtils;
import com.commonsware.cwac.camera.DeviceProfile;
import com.commonsware.cwac.camera.PictureTransaction;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SimpleCameraHost
implements CameraHost {
    private static final String[] SCAN_TYPES = new String[]{"image/jpeg"};
    private Context ctxt = null;
    private int cameraId = -1;
    private DeviceProfile profile = null;
    private File photoDirectory = null;
    private File videoDirectory = null;
    private CameraHost.RecordingHint recordingHint = null;
    private boolean mirrorFFC = false;
    private boolean useFrontFacingCamera = false;
    private boolean scanSavedImage = true;
    private boolean useFullBleedPreview = true;
    private boolean useSingleShotMode = false;

    public SimpleCameraHost(Context _ctxt) {
        this.ctxt = _ctxt.getApplicationContext();
    }

    public Camera.Parameters adjustPictureParameters(PictureTransaction xact, Camera.Parameters parameters) {
        return parameters;
    }

    public Camera.Parameters adjustPreviewParameters(Camera.Parameters parameters) {
        return parameters;
    }

    public void configureRecorderAudio(int cameraId, MediaRecorder recorder) {
        recorder.setAudioSource(5);
    }

    public void configureRecorderOutput(int cameraId, MediaRecorder recorder) {
        recorder.setOutputFile(this.getVideoPath().getAbsolutePath());
    }

    @TargetApi(value=11)
    public void configureRecorderProfile(int cameraId, MediaRecorder recorder) {
        if (Build.VERSION.SDK_INT < 11 || CamcorderProfile.hasProfile((int)cameraId, (int)1)) {
            recorder.setProfile(CamcorderProfile.get((int)cameraId, (int)1));
        } else if (Build.VERSION.SDK_INT >= 11 && CamcorderProfile.hasProfile((int)cameraId, (int)0)) {
            recorder.setProfile(CamcorderProfile.get((int)cameraId, (int)0));
        } else {
            throw new IllegalStateException("cannot find valid CamcorderProfile");
        }
    }

    public int getCameraId() {
        if (this.cameraId == -1) {
            this.initCameraId();
        }
        return this.cameraId;
    }

    private void initCameraId() {
        int count = Camera.getNumberOfCameras();
        int result = -1;
        if (count > 0) {
            result = 0;
            Camera.CameraInfo info = new Camera.CameraInfo();
            for (int i = 0; i < count; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing == 0 && !this.useFrontFacingCamera()) {
                    result = i;
                    break;
                }
                if (info.facing != 1 || !this.useFrontFacingCamera()) continue;
                result = i;
                break;
            }
        }
        this.cameraId = result;
    }

    public DeviceProfile getDeviceProfile() {
        if (this.profile == null) {
            this.initDeviceProfile(this.ctxt);
        }
        return this.profile;
    }

    private void initDeviceProfile(Context ctxt) {
        this.profile = DeviceProfile.getInstance(ctxt);
    }

    public Camera.Size getPictureSize(PictureTransaction xact, Camera.Parameters parameters) {
        return CameraUtils.getLargestPictureSize(this, parameters);
    }

    public Camera.Size getPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters) {
        return CameraUtils.getBestAspectPreviewSize(displayOrientation, width, height, parameters);
    }

    @TargetApi(value=11)
    public Camera.Size getPreferredPreviewSizeForVideo(int displayOrientation, int width, int height, Camera.Parameters parameters, Camera.Size deviceHint) {
        if (deviceHint != null) {
            return deviceHint;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            return parameters.getPreferredPreviewSizeForVideo();
        }
        return null;
    }

    public Camera.ShutterCallback getShutterCallback() {
        return null;
    }

    public void handleException(Exception e) {
        Log.e((String)this.getClass().getSimpleName(), (String)"Exception in setPreviewDisplay()", (Throwable)e);
    }

    public boolean mirrorFFC() {
        return this.mirrorFFC;
    }

    public void saveImage(PictureTransaction xact, Bitmap bitmap) {
    }

    public void saveImage(PictureTransaction xact, byte[] image, int imageOrientation) {
        File photo = this.getPhotoPath();
        if (photo.exists()) {
            photo.delete();
        }
        try {
            FileOutputStream fos = new FileOutputStream(photo.getPath());
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            bos.write(image);
            bos.flush();
            fos.getFD().sync();
            bos.close();
            if (this.scanSavedImage()) {
                MediaScannerConnection.scanFile((Context)this.ctxt, (String[])new String[]{photo.getPath()}, (String[])SCAN_TYPES, null);
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    @TargetApi(value=16)
    public void onAutoFocus(boolean success, Camera camera) {
        if (success && Build.VERSION.SDK_INT >= 16) {
            new MediaActionSound().play(1);
        }
    }

    public boolean useSingleShotMode() {
        return this.useSingleShotMode;
    }

    public void autoFocusAvailable() {
    }

    public void autoFocusUnavailable() {
    }

    public CameraHost.RecordingHint getRecordingHint() {
        if (this.recordingHint == null) {
            this.initRecordingHint();
        }
        return this.recordingHint;
    }

    private void initRecordingHint() {
        this.recordingHint = this.profile.getDefaultRecordingHint();
        if (this.recordingHint == CameraHost.RecordingHint.NONE) {
            this.recordingHint = CameraHost.RecordingHint.ANY;
        }
    }

    public void onCameraFail(CameraHost.FailureReason reason) {
        Log.e((String)"CWAC-Camera", (String)String.format("Camera access failed: %d", reason.value));
    }

    public boolean useFullBleedPreview() {
        return this.useFullBleedPreview;
    }

    public float maxPictureCleanupHeapUsage() {
        return 1.0f;
    }

    protected File getPhotoPath() {
        File dir = this.getPhotoDirectory();
        dir.mkdirs();
        return new File(dir, this.getPhotoFilename());
    }

    protected File getPhotoDirectory() {
        if (this.photoDirectory == null) {
            this.initPhotoDirectory();
        }
        return this.photoDirectory;
    }

    private void initPhotoDirectory() {
        this.photoDirectory = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
    }

    protected String getPhotoFilename() {
        String ts = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.US).format(new Date());
        return "Photo_" + ts + ".jpg";
    }

    protected File getVideoPath() {
        File dir = this.getVideoDirectory();
        dir.mkdirs();
        return new File(dir, this.getVideoFilename());
    }

    protected File getVideoDirectory() {
        if (this.videoDirectory == null) {
            this.initVideoDirectory();
        }
        return this.videoDirectory;
    }

    private void initVideoDirectory() {
        this.videoDirectory = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES);
    }

    protected String getVideoFilename() {
        String ts = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.US).format(new Date());
        return "Video_" + ts + ".mp4";
    }

    protected boolean useFrontFacingCamera() {
        return this.useFrontFacingCamera;
    }

    protected boolean scanSavedImage() {
        return this.scanSavedImage;
    }

    public static class Builder {
        private SimpleCameraHost host = null;

        public Builder(Context ctxt) {
            this(new SimpleCameraHost(ctxt));
        }

        public Builder(SimpleCameraHost host) {
            this.host = host;
        }

        public SimpleCameraHost build() {
            return this.host;
        }

        public Builder cameraId(int cameraId) {
            this.host.cameraId = cameraId;
            return this;
        }

        public Builder deviceProfile(DeviceProfile profile) {
            this.host.profile = profile;
            return this;
        }

        public Builder mirrorFFC(boolean mirrorFFC) {
            this.host.mirrorFFC = mirrorFFC;
            return this;
        }

        public Builder photoDirectory(File photoDirectory) {
            this.host.photoDirectory = photoDirectory;
            return this;
        }

        public Builder recordingHint(CameraHost.RecordingHint recordingHint) {
            this.host.recordingHint = recordingHint;
            return this;
        }

        public Builder scanSavedImage(boolean scanSavedImage) {
            this.host.scanSavedImage = scanSavedImage;
            return this;
        }

        public Builder useFrontFacingCamera(boolean useFrontFacingCamera) {
            this.host.useFrontFacingCamera = useFrontFacingCamera;
            return this;
        }

        public Builder useFullBleedPreview(boolean useFullBleedPreview) {
            this.host.useFullBleedPreview = useFullBleedPreview;
            return this;
        }

        public Builder useSingleShotMode(boolean useSingleShotMode) {
            this.host.useSingleShotMode = useSingleShotMode;
            return this;
        }

        public Builder videoDirectory(File videoDirectory) {
            this.host.videoDirectory = videoDirectory;
            return this;
        }
    }
}

