/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.billing;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Executor;
import net.doo.snap.lib.billing.BillingManager;
import net.doo.snap.lib.billing.Feature;
import net.doo.snap.lib.billing.ResolutionStrategy;

public class FeatureExecutor {
    private final BillingManager billingManager;
    private ResolutionStrategy resolutionStrategy;
    private Executor executor;
    private Handler mainThreadHandler = new Handler(Looper.getMainLooper());

    public FeatureExecutor(BillingManager billingManager) {
        this.billingManager = billingManager;
    }

    public static FeatureExecutor build(BillingManager billingManager) {
        return new FeatureExecutor(billingManager);
    }

    public FeatureExecutor setResolutionStrategy(ResolutionStrategy resolutionStrategy) {
        this.resolutionStrategy = resolutionStrategy;
        return this;
    }

    public FeatureExecutor setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public void executeFeature(Feature feature) {
        if (this.billingManager.isItemAvailable(feature.getId())) {
            feature.run();
        } else if (this.billingManager.isInitialized() && this.executor != null) {
            this.refreshItemsAndRetry(feature);
        }
    }

    private void refreshItemsAndRetry(final Feature feature) {
        this.executor.execute(new Runnable(){

            public void run() {
                if (!FeatureExecutor.this.billingManager.isItemAvailable(feature.getId())) {
                    FeatureExecutor.this.billingManager.refreshItems();
                }
                FeatureExecutor.this.mainThreadHandler.post(new Runnable(){

                    public void run() {
                        FeatureExecutor.this.retryFeatureExecution(feature);
                    }
                });
            }
        });
    }

    private void retryFeatureExecution(Feature feature) {
        if (this.billingManager.isItemAvailable(feature.getId())) {
            feature.run();
        } else if (this.resolutionStrategy != null) {
            this.resolutionStrategy.resolveNotAvailableFeature(feature);
        }
    }
}

