/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.lib.analytics.ActivityAnalytics;
import net.doo.snap.lib.analytics.EasyTrackerWrapper;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.PictureProcessor;
import net.doo.snap.lib.snap.camera.CameraPreviewFragment;
import net.doo.snap.lib.snap.event.PictureTakenEvent;
import net.doo.snap.lib.snap.util.OrientationLocker;
import net.doo.snap.lib.ui.util.ViewUtils;
import net.doo.snap.lib.util.log.DebugLog;
import roboguice.activity.RoboFragmentActivity;
import roboguice.event.Observes;

public class CameraActivity
extends RoboFragmentActivity {
    public static final String PAGE_POSITION = "PAGE_POSITION";
    public static final String RESULT_PAGE = "RESULT_PAGE";
    @Inject
    private PictureProcessor pictureProcessor;
    @Inject
    private ActivityAnalytics activityAnalytics;
    @Inject
    private OrientationLocker orientationLocker;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903046);
        final CameraPreviewFragment cameraPreviewFragment = (CameraPreviewFragment)this.getSupportFragmentManager().findFragmentById(2131165211);
        ViewUtils.postOnPreDraw(this.findViewById(2131165211), new Runnable(){

            public void run() {
                cameraPreviewFragment.setPreviewMode(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPictureTaken(@Observes PictureTakenEvent event) {
        Page page = null;
        try {
            long pictureProcessingStart = SystemClock.elapsedRealtime();
            page = this.pictureProcessor.processBytes(event.getImage(), event.getImageOrientation());
            long processingDuration = SystemClock.elapsedRealtime() - pictureProcessingStart;
            EasyTrackerWrapper.sendTiming("timing_snapping", processingDuration, "saving_snapped_page", null);
            this.deliverResult(page);
        }
        catch (IOException e) {
            DebugLog.logException(e);
        }
        finally {
            this.deliverResult(page);
        }
    }

    private void deliverResult(final Page page) {
        this.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (page != null) {
                        Intent intent = new Intent();
                        intent.putExtra(CameraActivity.RESULT_PAGE, (Parcelable)page);
                        intent.putExtra(CameraActivity.PAGE_POSITION, CameraActivity.this.getIntent().getIntExtra(CameraActivity.PAGE_POSITION, 0));
                        CameraActivity.this.setResult(-1, intent);
                    }
                }
                finally {
                    CameraActivity.this.finish();
                }
            }
        });
    }
}

