/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.persistence;

import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.util.DisplayMetrics;
import com.google.inject.Inject;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.persistence.OptimizationType;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.PageFactory;
import net.doo.snap.lib.persistence.PageStoreStrategy;
import net.doo.snap.lib.persistence.RotationType;
import net.doo.snap.lib.util.bitmap.BitmapLruCache;
import net.doo.snap.lib.util.log.DebugLog;
import org.apache.commons.io.IOUtils;

public class PictureProcessor {
    private static final int JPEG_QUALITY = 90;
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final float FILTERED_PREVIEW_SCALE = 0.65f;
    @Inject
    private BitmapLruCache bitmapLruCache;
    private PageFactory pageFactory;
    private PageStoreStrategy pageStoreStrategy;
    private Resources resources;
    private SharedPreferences preferences;

    @Inject
    public PictureProcessor(PageFactory pageFactory, PageStoreStrategy pageStoreStrategy, Resources resources, SharedPreferences preferences) {
        this.pageFactory = pageFactory;
        this.pageStoreStrategy = pageStoreStrategy;
        this.resources = resources;
        this.preferences = preferences;
    }

    public Page processBytes(byte[] image, int imageOrientation) throws IOException {
        DisplayMetrics displayMetrics = this.resources.getDisplayMetrics();
        PageFactory.Result result = this.pageFactory.buildPage(image, displayMetrics.widthPixels, displayMetrics.heightPixels);
        Page page = result.page;
        page.setRotationType(RotationType.getByDegrees(imageOrientation));
        if (this.preferences.contains("LAST_USED_FILTER")) {
            page.setOptimizationType(OptimizationType.getByCode(this.preferences.getInt("LAST_USED_FILTER", OptimizationType.NONE.getCode())));
        }
        ContourDetector detector = new ContourDetector();
        detector.detect(result.preview);
        List<PointF> polygon = detector.getPolygonF();
        page.setPolygon(polygon);
        this.generateOptimizedPreview(this.pageStoreStrategy, page, result.preview, detector);
        return page;
    }

    private void generateOptimizedPreview(PageStoreStrategy pageStoreStrategy, Page page, Bitmap preview, ContourDetector detector) throws IOException {
        List<PointF> polygon = page.getPolygon();
        if (!polygon.isEmpty()) {
            final Bitmap bitmap = detector.processImageF(preview, polygon, page.getOptimizationType().getCode());
            final String path = pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED_PREVIEW).getPath();
            this.bitmapLruCache.put(path, bitmap);
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(path);
                        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
                    }
                    catch (IOException e) {
                        try {
                            DebugLog.logException(e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fos);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((OutputStream)fos);
                    }
                    IOUtils.closeQuietly((OutputStream)fos);
                }
            });
            PictureProcessor.generateFilteredPreviewAsync(pageStoreStrategy, page, preview, detector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateOptimizedPreview(PageStoreStrategy pageStoreStrategy, Page page, ContourDetector detector) throws IOException {
        block2: {
            List<PointF> polygon = page.getPolygon();
            if (polygon.isEmpty()) break block2;
            String previewPath = pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.PREVIEW).getPath();
            Bitmap preview = BitmapFactory.decodeFile((String)previewPath);
            Bitmap bitmap = detector.processImageF(preview, polygon, page.getOptimizationType().getCode());
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED_PREVIEW));
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
            PictureProcessor.generateFilteredPreviewAsync(pageStoreStrategy, page, preview, detector);
        }
    }

    private static void generateFilteredPreviewAsync(final PageStoreStrategy pageStoreStrategy, final Page page, final Bitmap preview, final ContourDetector detector) {
        executor.execute(new Runnable(){

            public void run() {
                try {
                    PictureProcessor.generateFilteredPreview(pageStoreStrategy, page, preview, detector);
                }
                catch (IOException e) {
                    DebugLog.logException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateFilteredPreview(PageStoreStrategy pageStoreStrategy, Page page, Bitmap preview, ContourDetector detector) throws IOException {
        Matrix matrix = new Matrix();
        matrix.setScale(0.65f, 0.65f);
        Bitmap downscaledPreview = Bitmap.createBitmap((Bitmap)preview, (int)0, (int)0, (int)preview.getWidth(), (int)preview.getHeight(), (Matrix)matrix, (boolean)true);
        for (OptimizationType optimizationType : OptimizationType.values()) {
            Bitmap processed = detector.processImageF(downscaledPreview, page.getPolygon(), optimizationType.getCode());
            FileOutputStream fos = new FileOutputStream(pageStoreStrategy.getFilteredPreviewFile(page.getId(), optimizationType));
            try {
                processed.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }
    }
}

