/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.edit;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import com.google.inject.Inject;
import net.doo.snap.lib.snap.edit.events.DocumentRenamedEvent;
import net.doo.snap.lib.ui.HoloDialogFragment;
import net.doo.snap.lib.util.FileUtils;
import roboguice.event.EventManager;

public class RenameDocumentFragment
extends HoloDialogFragment {
    @Inject
    private EventManager eventManager;
    private EditText nameView;
    private AlertDialog dialog;

    public static RenameDocumentFragment newInstance(Bundle args) {
        RenameDocumentFragment fragment = new RenameDocumentFragment();
        fragment.setArguments(args);
        return fragment;
    }

    protected View onCreateContentView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        String currentName = args.getString("CURRENT_NAME");
        int titleRes = args.getInt("TITLE", 2131230779);
        int hintRes = args.getInt("HINT", 2131230780);
        this.setTitle(titleRes);
        this.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RenameDocumentFragment.this.eventManager.fire((Object)new DocumentRenamedEvent(RenameDocumentFragment.this.nameView.getText().toString()));
                RenameDocumentFragment.this.dismiss();
            }
        });
        this.setNegativeButton(0x1040000, null);
        View content = LayoutInflater.from((Context)this.getActivity()).inflate(2130903058, null);
        this.nameView = (EditText)content.findViewById(2131165233);
        this.nameView.setText((CharSequence)currentName);
        this.nameView.setHint(hintRes);
        return content;
    }

    public void onStart() {
        super.onStart();
        this.getDialog().getWindow().setSoftInputMode(21);
        final Button positiveButton = this.getButton(-1);
        this.nameView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                positiveButton.setEnabled(FileUtils.isFileNameSafe(s));
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }
}

