package net.doo.snap.lib.ui;

import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import com.google.inject.Inject;

import net.doo.snap.lib.R;

/**
 * UI shown with the explanation that Nexus 4 device was rebooted because of the camera bug
 */
public class Nexus4RebootFragment extends HoloDialogFragment {

    private static final String NEXUS_4_TAG = "NEXUS_4_TAG";

    @Inject
    private SharedPreferences preferences;

    public static Nexus4RebootFragment newInstance() {
        return new Nexus4RebootFragment();
    }

    /**
     * shows {@link net.doo.snap.lib.ui.Nexus4RebootFragment} if current device model is Nexus 4
     *
     * @param fm
     */
    public void showIfNexus4(FragmentManager fm) {
        if (!TextUtils.isEmpty(Build.MODEL)
                && !TextUtils.isEmpty(Build.MANUFACTURER)
                && Build.MODEL.toUpperCase().matches("NEXUS.*4")
                && Build.MANUFACTURER.toUpperCase().contains("LGE")
                && fm.findFragmentByTag(NEXUS_4_TAG) == null) {
            show(fm, NEXUS_4_TAG);
        }
    }

    @Override
    protected View onCreateContentView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        setTitle(R.string.nexus_4_reboot_fragment_title);
        setPositiveButton(android.R.string.ok, null);
        setNeutralButton(R.string.nexus_4_reboot_fragment_support_title, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                Intent intent = new Intent(Intent.ACTION_VIEW);
                intent.setData(Uri.parse("https://support.google.com/nexus/"));
                if (intent.resolveActivity(getActivity().getPackageManager()) != null) {
                    startActivity(intent);
                } else {
                    Toast.makeText(getActivity(), getString(R.string.nexus_4_fragment_browser_error), Toast.LENGTH_LONG).show();
                }
            }
        });
        TextView message = (TextView) inflater.inflate(R.layout.nexus_4_fragment, container, false);
        message.setText(R.string.nexus_4_reboot_fragment_text);

        return message;
    }
}
