/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.preview.zoom;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import com.google.inject.Inject;
import net.doo.snap.lib.snap.edit.EditLock;
import net.doo.snap.lib.snap.preview.zoom.PreScaleChangedEvent;
import net.doo.snap.lib.snap.preview.zoom.PrepareZoomEvent;
import net.doo.snap.lib.snap.preview.zoom.QuickScaleEvent;
import net.doo.snap.lib.snap.preview.zoom.StartZoomingEvent;
import net.doo.snap.lib.snap.preview.zoom.ZoomingFinishedEvent;
import net.doo.snap.lib.ui.util.ViewUtils;
import org.jetbrains.annotations.NotNull;
import roboguice.event.EventManager;
import roboguice.event.Observes;

public class ZoomingManager {
    @Inject
    private EventManager eventManager;
    @Inject
    private Activity activity;
    @Inject
    private EditLock editLock;
    private View initialView;
    private ZoomingCallbacks zoomingCallbacks;

    @Inject
    public ZoomingManager() {
    }

    public void init(@NotNull View initialView, @NotNull ZoomingCallbacks zoomingCallbacks) {
        this.initialView = initialView;
        this.zoomingCallbacks = zoomingCallbacks;
    }

    public ScaleGestureDetector buildScaleDetector() {
        this.ensureInitialized();
        return new ScaleGestureDetector((Context)this.activity, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
    }

    public GestureDetector buildDobuleTapDetector() {
        this.ensureInitialized();
        return new GestureDetector((Context)this.activity, (GestureDetector.OnGestureListener)new GestureListener());
    }

    private boolean prepareToScaling() {
        if (!this.zoomingCallbacks.isZoomingEnabled()) {
            return false;
        }
        Drawable scaledDrawable = this.zoomingCallbacks.getZoomedDrawable();
        this.editLock.lockEdit();
        this.activity.getActionBar().hide();
        this.eventManager.fire((Object)new PrepareZoomEvent(scaledDrawable, ViewUtils.getViewBounds(this.initialView), this.zoomingCallbacks.getToken()));
        this.initialView.setVisibility(4);
        return true;
    }

    private void startScaling() {
        this.eventManager.fire((Object)new StartZoomingEvent());
    }

    private void quickScale() {
        this.eventManager.fire((Object)new QuickScaleEvent());
    }

    private void onScaleEnded(@Observes ZoomingFinishedEvent event) {
        if (this.zoomingCallbacks != null && event.getToken().equals(this.zoomingCallbacks.getToken())) {
            this.initialView.setVisibility(0);
            this.activity.getActionBar().show();
            this.editLock.unlockEdit();
        }
    }

    private void ensureInitialized() {
        if (this.initialView == null || this.zoomingCallbacks == null) {
            throw new IllegalStateException("ZoomingManager is not initialized.");
        }
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private float currentScale;
        private PreScaleChangedEvent preScaleChangedEvent = new PreScaleChangedEvent();

        private ScaleListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            ZoomingManager.this.ensureInitialized();
            this.currentScale = 1.0f;
            return ZoomingManager.this.prepareToScaling();
        }

        public boolean onScale(ScaleGestureDetector detector) {
            this.currentScale *= detector.getScaleFactor();
            if (this.currentScale < 1.0f) {
                this.currentScale = 1.0f;
            }
            this.preScaleChangedEvent.scale = this.currentScale;
            ZoomingManager.this.eventManager.fire((Object)this.preScaleChangedEvent);
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            ZoomingManager.this.startScaling();
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            ZoomingManager.this.ensureInitialized();
            if (!ZoomingManager.this.zoomingCallbacks.isZoomingEnabled()) {
                return false;
            }
            boolean prepared = ZoomingManager.this.prepareToScaling();
            if (!prepared) {
                return false;
            }
            ZoomingManager.this.quickScale();
            return true;
        }
    }

    public static interface ZoomingCallbacks {
        @NotNull
        public Drawable getZoomedDrawable();

        public Object getToken();

        public boolean isZoomingEnabled();
    }
}

