/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class BitmapUtils {
    public static Rect getBitmapBounds(String path) {
        Rect bounds = new Rect();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        bounds.set(0, 0, options.outWidth, options.outHeight);
        return bounds;
    }

    public static boolean isBitmapValid(Bitmap bitmap) {
        return bitmap != null && !bitmap.isRecycled();
    }

    public static Rect getContentBounds(Bitmap bitmap) throws NullPointerException {
        if (bitmap == null) {
            throw new NullPointerException("Bitmap is null");
        }
        int minX = bitmap.getWidth();
        int minY = bitmap.getHeight();
        int maxX = 0;
        int maxY = 0;
        for (int y = 0; y < bitmap.getHeight(); ++y) {
            for (int x = 0; x < bitmap.getWidth(); ++x) {
                int pixel = bitmap.getPixel(x, y);
                if (pixel == 0) continue;
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        return new Rect(minX, minY, maxX, maxY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(Bitmap bitmap, Bitmap.CompressFormat format, int quality, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bitmap.compress(format, quality, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public static Bitmap createPreview(byte[] image, int targetWidth, int targetHeight) {
        if (image == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, targetWidth, targetHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length, (BitmapFactory.Options)options);
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        boolean desiredLandscape;
        int width = options.outWidth;
        int height = options.outHeight;
        boolean imageLandscape = width > height;
        boolean bl = desiredLandscape = reqWidth > reqHeight;
        if (imageLandscape != desiredLandscape) {
            height = options.outWidth;
            width = options.outHeight;
        }
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static Bitmap decodeQuietly(@Nullable String path, @Nullable BitmapFactory.Options options) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }
}

