package net.doo.snap.lib.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import net.doo.snap.lib.R;

import roboguice.fragment.RoboDialogFragment;

/**
 * Displays {@link roboguice.fragment.RoboDialogFragment} styled as on Honeycomb
 */
public abstract class HoloDialogFragment extends RoboDialogFragment {

    private int titleResource;
    private int negativeButtonTitleResource;
    private int neutralButtonTitleResource;
    private int positiveButtonTitleResource;
    private DialogInterface.OnClickListener negativeClickListener;
    private DialogInterface.OnClickListener neutralClickListener;
    private DialogInterface.OnClickListener positiveClickListener;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setStyle(STYLE_NO_FRAME, R.style.SnapLib_Dialog);
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());

        LayoutInflater inflater = LayoutInflater.from(getActivity());

        View rootView = inflater.inflate(R.layout.holo_dialog_frame, null, false);
        ViewGroup contentContainer = (ViewGroup) rootView.findViewById(R.id.content);
        View contentView = onCreateContentView(inflater, contentContainer, savedInstanceState);
        contentContainer.addView(contentView);
        updateHeader(rootView);

        builder.setView(rootView);

        if (negativeButtonTitleResource != 0) {
            builder.setNegativeButton(negativeButtonTitleResource, negativeClickListener);
        }
        if (neutralButtonTitleResource != 0) {
            builder.setNeutralButton(neutralButtonTitleResource, neutralClickListener);
        }
        if (positiveButtonTitleResource != 0) {
            builder.setPositiveButton(positiveButtonTitleResource, positiveClickListener);
        }

        Dialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    /**
     * Override this method instead of
     * {@link android.support.v4.app.Fragment#onCreateView(android.view.LayoutInflater, android.view.ViewGroup, android.os.Bundle)}
     */
    protected abstract View onCreateContentView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState);

    private void updateHeader(View rootView) {
        if (rootView == null) {
            return;
        }

        TextView titleTextView = (TextView) rootView.findViewById(R.id.title);
        if (titleResource == 0) {
            titleTextView.setVisibility(View.GONE);
            rootView.findViewById(R.id.title_divider).setVisibility(View.GONE);
            return;
        }

        titleTextView.setText(titleResource);
    }

    /**
     * @param res - title resource of dialog. If <code>0</code> provided - title won't be displayed
     */
    protected final void setTitle(int res) {
        this.titleResource = res;
    }

    /**
     * @param res                 - title resource for this button. If <code>0</code> provided - button won't be displayed.
     * @param listener            - listener for this button. If <code>null</code> provided - dialog will be canceled by click on this button.
     */
    protected final void setNegativeButton(int res, DialogInterface.OnClickListener listener) {
        this.negativeButtonTitleResource = res;
        this.negativeClickListener = listener;
    }

    /**
     * @param res                 - title resource for this button. If <code>0</code> provided - button won't be displayed.
     * @param listener            - listener for this button. If <code>null</code> provided - dialog will be canceled by click on this button.
     */
    public final void setNeutralButton(int res, DialogInterface.OnClickListener listener) {
        this.neutralButtonTitleResource = res;
        this.neutralClickListener = listener;
    }

    /**
     * @param res                 - title resource for this button. If <code>0</code> provided - button won't be displayed.
     * @param listener            - listener for this button. If <code>null</code> provided - dialog will be canceled by click on this button.
     */
    protected final void setPositiveButton(int res, DialogInterface.OnClickListener listener) {
        this.positiveButtonTitleResource = res;
        this.positiveClickListener = listener;
    }

    /**
     *
     * @param buttonId button Id such as {@link android.content.DialogInterface#BUTTON_POSITIVE)
     * @return Button view for given id
     */
    protected Button getButton(int buttonId) {
        return ((AlertDialog) getDialog()).getButton(buttonId);
    }
}
