package net.doo.snap.lib.smartname;

import net.doo.snap.lib.R;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Represents all term types categories
 */
public enum TermTypeCategory {

    SPECIAL(R.string.term_category_special, TermType.CITY, TermType.DEVICE_MODEL),
    DATE(R.string.term_category_date, TermType.YEAR, TermType.YEAR_SHORT, TermType.MONTH, TermType.DAY),
    TIME(R.string.term_category_time, TermType.HOURS, TermType.MINUTES, TermType.SECONDS);

    private final List<TermType> termTypes;
    private final int displayNameResId;

    TermTypeCategory(int displayNameResId, TermType... termTypes) {
        this.displayNameResId = displayNameResId;
        this.termTypes = Collections.unmodifiableList(Arrays.asList(termTypes));
    }

    /**
     * @return all {@link net.doo.snap.lib.smartname.TermType} associated with this category
     */
    public List<TermType> getTermTypes() {
        return termTypes;
    }

    /**
     * @return category display name resource id
     */
    public int getDisplayNameResId() {
        return displayNameResId;
    }
}
