package net.doo.snap.lib.snap.preview.zoom;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;

/**
 * Fired when pinch-to-zoom gesture was first detected. During preparation {@link ZoomedPreviewFragment}
 * will assign {@link android.graphics.drawable.Drawable} and correct position to it's view
 */
public class PrepareZoomEvent {

    private final Drawable drawable;
    private final Rect containerBounds;
    private final Object token;

    public PrepareZoomEvent(Drawable drawable, Rect containerBounds, Object token) {
        this.drawable = drawable;
        this.containerBounds = containerBounds;
        this.token = token;
    }

    /**
     * @return {@link android.graphics.drawable.Drawable} which will be used for zooming
     */
    public Drawable getDrawable() {
        return drawable;
    }

    /**
     * @return bounds of {@link android.view.View} that was holding the initial image
     */
    public Rect getInitialBounds() {
        return containerBounds;
    }

    /**
     * @return token that uniquely identifies entity being zoomed
     */
    public Object getToken() {
        return token;
    }
}
