package net.doo.snap.lib.util.billing;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Represents an in-app billing purchase.
 */
public class Purchase {
    private String itemType;  // ITEM_TYPE_INAPP or ITEM_TYPE_SUBS
    private String orderId;
    private String packageName;
    private String sku;
    private long purchaseTime;
    private int purchaseState;
    private String developerPayload;
    private String token;
    private String originalJson;
    private String signature;

    public Purchase(String itemType, String jsonPurchaseInfo, String signature) throws JSONException {
        this.itemType = itemType;
        originalJson = jsonPurchaseInfo;
        JSONObject jsonObject = new JSONObject(originalJson);
        orderId = jsonObject.optString("orderId");
        packageName = jsonObject.optString("packageName");
        sku = jsonObject.optString("productId");
        purchaseTime = jsonObject.optLong("purchaseTime");
        purchaseState = jsonObject.optInt("purchaseState");
        developerPayload = jsonObject.optString("developerPayload");
        token = jsonObject.optString("token", jsonObject.optString("purchaseToken"));
        this.signature = signature;
    }

    /**
     * @return item type {@link net.doo.snap.lib.util.billing.IabHelper#ITEM_TYPE_INAPP} or {@link net.doo.snap.lib.util.billing.IabHelper#ITEM_TYPE_SUBS}
     */
    public String getItemType() {
        return itemType;
    }

    /**
     * @return order id
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * @return package name
     */
    public String getPackageName() {
        return packageName;
    }

    /**
     * @return item sku
     */
    public String getSku() {
        return sku;
    }

    /**
     * @return purchase time
     */
    public long getPurchaseTime() {
        return purchaseTime;
    }

    /**
     * @return purchase state
     */
    public int getPurchaseState() {
        return purchaseState;
    }

    /**
     * @return developer payload
     */
    public String getDeveloperPayload() {
        return developerPayload;
    }

    /**
     * @return operation token
     */
    public String getToken() {
        return token;
    }

    /**
     * @return original response json
     */
    public String getOriginalJson() {
        return originalJson;
    }

    /**
     * @return operation signature
     */
    public String getSignature() {
        return signature;
    }

    @Override
    public String toString() {
        return "PurchaseInfo(type:" + itemType + "):" + originalJson;
    }
}
