/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.DeviceProfile;
import org.xmlpull.v1.XmlPullParser;

public class SimpleDeviceProfile
extends DeviceProfile {
    private boolean useTextureView = Build.VERSION.SDK_INT >= 15 && !this.isCustomRom();
    private boolean portraitFFCFlipped = false;
    private int minPictureHeight = 0;
    private int maxPictureHeight = Integer.MAX_VALUE;
    private boolean doesZoomActuallyWork = true;
    private int defaultOrientation = -1;
    private boolean useDeviceOrientation = false;
    private int pictureDelay = 0;
    private CameraHost.RecordingHint recordingHint = CameraHost.RecordingHint.NONE;

    SimpleDeviceProfile load(XmlPullParser xpp) {
        StringBuilder buf = null;
        try {
            while (xpp.getEventType() != 1) {
                switch (xpp.getEventType()) {
                    case 2: {
                        buf = new StringBuilder();
                        break;
                    }
                    case 4: {
                        if (buf == null) break;
                        buf.append(xpp.getText());
                        break;
                    }
                    case 3: {
                        if (buf == null) break;
                        this.set(xpp.getName(), buf.toString().trim());
                    }
                }
                xpp.next();
            }
        }
        catch (Exception e) {
            Log.e((String)"CWAC-Camera", (String)String.format("Exception parsing device profile for %s %s", Build.MANUFACTURER, Build.MODEL), (Throwable)e);
        }
        return this;
    }

    @SuppressLint(value={"DefaultLocale"})
    private void set(String name, String value) {
        if ("useTextureView".equals(name)) {
            this.useTextureView = Boolean.parseBoolean(value);
        } else if ("portraitFFCFlipped".equals(name)) {
            this.portraitFFCFlipped = Boolean.parseBoolean(value);
        } else if ("doesZoomActuallyWork".equals(name)) {
            this.doesZoomActuallyWork = Boolean.parseBoolean(value);
        } else if ("useDeviceOrientation".equals(name)) {
            this.useDeviceOrientation = Boolean.parseBoolean(value);
        } else if ("minPictureHeight".equals(name)) {
            this.minPictureHeight = Integer.parseInt(value);
        } else if ("maxPictureHeight".equals(name)) {
            this.maxPictureHeight = Integer.parseInt(value);
        } else if ("pictureDelay".equals(name)) {
            this.pictureDelay = Integer.parseInt(value);
        } else if ("recordingHint".equals(name)) {
            String hint = value.toUpperCase();
            if ("ANY".equals(hint)) {
                this.recordingHint = CameraHost.RecordingHint.ANY;
            } else if ("STILL_ONLY".equals(hint)) {
                this.recordingHint = CameraHost.RecordingHint.STILL_ONLY;
            } else if ("VIDEO_ONLY".equals(hint)) {
                this.recordingHint = CameraHost.RecordingHint.VIDEO_ONLY;
            }
        }
    }

    @Override
    public boolean useTextureView() {
        return this.useTextureView;
    }

    @Override
    public boolean portraitFFCFlipped() {
        return this.portraitFFCFlipped;
    }

    @Override
    public int getMinPictureHeight() {
        return this.minPictureHeight;
    }

    @Override
    public int getMaxPictureHeight() {
        return this.maxPictureHeight;
    }

    @Override
    public boolean doesZoomActuallyWork(boolean isFFC) {
        return this.doesZoomActuallyWork;
    }

    @Override
    public int getDefaultOrientation() {
        return this.defaultOrientation;
    }

    @Override
    public boolean useDeviceOrientation() {
        return this.useDeviceOrientation;
    }

    @Override
    public int getPictureDelay() {
        return this.pictureDelay;
    }

    @Override
    public CameraHost.RecordingHint getDefaultRecordingHint() {
        return this.recordingHint;
    }

    static class MotorolaRazrI
    extends SimpleDeviceProfile {
        MotorolaRazrI() {
        }

        @Override
        public boolean doesZoomActuallyWork(boolean isFFC) {
            return !isFFC;
        }
    }
}

