package net.doo.snap.lib.util.smartname;

import net.doo.snap.lib.smartname.TermType;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import static net.doo.snap.lib.smartname.SmartNameGenerator.SEPARATOR;

/**
 * Provides util methods for smartnaming
 */
public class SmartNameUtil {

    /**
     * Parses terms in preferences format (ids separated with "|" character)
     * @param termsString
     * @return {@link List<net.doo.snap.lib.smartname.TermType>} parsed terms
     */
    public static List<TermType> convertTermsFromPreferencesFormat(String termsString) {
        List<TermType> termsList = new ArrayList<>();
        StringTokenizer typesTokenizer = new StringTokenizer(termsString, SEPARATOR);
        int count = typesTokenizer.countTokens();
        for (int i = 0; i < count; i++) {
            int termTypeId = Integer.parseInt(typesTokenizer.nextToken());
            termsList.add(TermType.getTermTypeById(termTypeId));
        }
        return termsList;
    }

}
