/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.smartname;

import android.content.SharedPreferences;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.doo.snap.lib.smartname.SmartNameValuesProvider;
import net.doo.snap.lib.smartname.TermType;
import net.doo.snap.lib.util.smartname.SmartNameUtil;
import org.apache.commons.lang.StringUtils;

public class SmartNameGenerator {
    public static final String SEPARATOR = "|";
    public static final String TERM_CHARACTER = "\t";
    public static final String DEFAULT_TEMPLATE = "Scan \t-\t-\t \t.\t.\t";
    public static final List<TermType> DEFAULT_TERMS = Arrays.asList(TermType.YEAR, TermType.MONTH, TermType.DAY, TermType.HOURS, TermType.MINUTES, TermType.SECONDS);
    private static final Pattern PATTERN = Pattern.compile("\t");
    private final SharedPreferences preferences;
    private final SmartNameValuesProvider smartNameValuesProvider;

    @Inject
    public SmartNameGenerator(SharedPreferences preferences, SmartNameValuesProvider smartNameValuesProvider) {
        this.preferences = preferences;
        this.smartNameValuesProvider = smartNameValuesProvider;
    }

    public String generateDocumentName(String template, List<TermType> terms) {
        Matcher matcher = PATTERN.matcher(template);
        StringBuffer resultBuilder = new StringBuffer();
        int index = 0;
        while (matcher.find()) {
            matcher.appendReplacement(resultBuilder, this.smartNameValuesProvider.getTermValue(terms.get(index++)));
        }
        matcher.appendTail(resultBuilder);
        return resultBuilder.toString();
    }

    public String generateDocumentName() {
        String template = this.preferences.getString("SMART_NAME_TEMPLATE", null);
        String termsTypes = this.preferences.getString("SMART_NAME_TERMS_TYPES", null);
        ArrayList<TermType> terms = new ArrayList<TermType>();
        if (StringUtils.isEmpty((String)template)) {
            template = DEFAULT_TEMPLATE;
            terms.addAll(DEFAULT_TERMS);
        } else {
            if (StringUtils.isEmpty((String)termsTypes)) {
                return template;
            }
            terms.addAll(SmartNameUtil.convertTermsFromPreferencesFormat(termsTypes));
        }
        return this.generateDocumentName(template, terms);
    }
}

