package net.doo.snap.lib.ui;

import android.os.Bundle;
import android.preference.PreferenceManager;

import net.doo.snap.lib.PreferencesConstants;
import net.doo.snap.lib.ui.themes.Theme;
import net.doo.snap.lib.ui.themes.ThemesProvider;

import roboguice.RoboGuice;
import roboguice.activity.RoboFragmentActivity;
import roboguice.inject.RoboInjector;

/**
 * Applies custom theme stored in preferences
 */
public class CustomThemeActivity extends RoboFragmentActivity {

    private ThemesProvider themesProvider;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        themesProvider = initThemesProvider();

        Theme theme = Theme.getThemeById(PreferenceManager.getDefaultSharedPreferences(this).getInt(PreferencesConstants.CURRENT_THEME, Theme.SCANBOT.getId()));
        setTheme(themesProvider.getThemeResId(theme));
        super.onCreate(savedInstanceState);
    }

    protected ThemesProvider initThemesProvider() {
        final RoboInjector injector = RoboGuice.getInjector(this);
        return injector.getProvider(ThemesProvider.class).get();
    }

}
