/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import android.content.Context;
import android.telephony.PhoneNumberUtils;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.ParsedResult;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.doo.snap.lib.snap.camera.barcode.result.ResultHandler;
import net.doo.snap.lib.util.ThemesHelper;

public final class AddressBookResultHandler
extends ResultHandler {
    private static final DateFormat[] DATE_FORMATS;
    private static final int[] BUTTON_TEXTS;
    private static final int DISABLED_FIELD = -1;
    private static final int ADD_TO_CONTACTS = 0;
    private static final int SEARCH_MAP = 1;
    private static final int CALL = 2;
    private static final int SEND_MAIL = 3;
    private final List<Integer> fields;
    private int buttonCount;

    public AddressBookResultHandler(Activity activity, AddressBookParsedResult addressResult) {
        super(activity, (ParsedResult)addressResult);
        String[] addresses = this.getResult().getAddresses();
        boolean hasAddress = addresses != null && addresses.length > 0 && addresses[0] != null && !addresses[0].isEmpty();
        String[] phoneNumbers = this.getResult().getPhoneNumbers();
        boolean hasPhoneNumber = phoneNumbers != null && phoneNumbers.length > 0;
        String[] emails = this.getResult().getEmails();
        boolean hasEmailAddress = emails != null && emails.length > 0;
        int index = 0;
        this.fields = Arrays.asList(index++, hasAddress ? index++ : -1, hasPhoneNumber ? index++ : -1, hasEmailAddress ? index++ : -1);
        this.buttonCount = index;
    }

    private int mapIndexToAction(int index) {
        return this.fields.indexOf(index);
    }

    public AddressBookParsedResult getResult() {
        return (AddressBookParsedResult)super.getResult();
    }

    @Override
    public int getButtonCount() {
        return this.buttonCount;
    }

    @Override
    public int getButtonText(int index) {
        return BUTTON_TEXTS[this.mapIndexToAction(index)];
    }

    @Override
    public void handleButtonPress(int index) {
        AddressBookParsedResult addressResult = this.getResult();
        String[] addresses = addressResult.getAddresses();
        String address1 = addresses == null || addresses.length < 1 ? null : addresses[0];
        String[] addressTypes = addressResult.getAddressTypes();
        String address1Type = addressTypes == null || addressTypes.length < 1 ? null : addressTypes[0];
        int action = this.mapIndexToAction(index);
        switch (action) {
            case 0: {
                this.addContact(addressResult.getNames(), addressResult.getNicknames(), addressResult.getPronunciation(), addressResult.getPhoneNumbers(), addressResult.getPhoneTypes(), addressResult.getEmails(), addressResult.getEmailTypes(), addressResult.getNote(), addressResult.getInstantMessenger(), address1, address1Type, addressResult.getOrg(), addressResult.getTitle(), addressResult.getURLs(), addressResult.getBirthday(), addressResult.getGeo());
                break;
            }
            case 1: {
                this.searchMap(address1);
                break;
            }
            case 2: {
                this.dialPhone(addressResult.getPhoneNumbers()[0]);
                break;
            }
            case 3: {
                this.sendEmail(addressResult.getEmails()[0], null, null);
            }
        }
    }

    private static Date parseDate(String s) {
        for (DateFormat currentFormat : DATE_FORMATS) {
            try {
                return currentFormat.parse(s);
            }
            catch (ParseException e) {
            }
        }
        return null;
    }

    @Override
    public CharSequence getDisplayContents() {
        Date date;
        AddressBookParsedResult result = this.getResult();
        StringBuilder contents = new StringBuilder(100);
        ParsedResult.maybeAppend((String[])result.getNames(), (StringBuilder)contents);
        int namesLength = contents.length();
        String pronunciation = result.getPronunciation();
        if (!TextUtils.isEmpty((CharSequence)pronunciation)) {
            contents.append("\n(");
            contents.append(pronunciation);
            contents.append(')');
        }
        ParsedResult.maybeAppend((String)result.getTitle(), (StringBuilder)contents);
        ParsedResult.maybeAppend((String)result.getOrg(), (StringBuilder)contents);
        ParsedResult.maybeAppend((String[])result.getAddresses(), (StringBuilder)contents);
        String[] numbers = result.getPhoneNumbers();
        if (numbers != null) {
            for (String number : numbers) {
                if (TextUtils.isEmpty((CharSequence)number)) continue;
                ParsedResult.maybeAppend((String)PhoneNumberUtils.formatNumber((String)number), (StringBuilder)contents);
            }
        }
        ParsedResult.maybeAppend((String[])result.getEmails(), (StringBuilder)contents);
        ParsedResult.maybeAppend((String[])result.getURLs(), (StringBuilder)contents);
        String birthday = result.getBirthday();
        if (!TextUtils.isEmpty((CharSequence)birthday) && (date = AddressBookResultHandler.parseDate(birthday)) != null) {
            ParsedResult.maybeAppend((String)DateFormat.getDateInstance(2).format(date.getTime()), (StringBuilder)contents);
        }
        ParsedResult.maybeAppend((String)result.getNote(), (StringBuilder)contents);
        if (namesLength > 0) {
            SpannableString styled = new SpannableString((CharSequence)contents.toString());
            styled.setSpan((Object)new StyleSpan(1), 0, namesLength, 0);
            return styled;
        }
        return contents.toString();
    }

    @Override
    public String getDisplayTitle() {
        AddressBookParsedResult addressResult = this.getResult();
        return addressResult.getNames().length == 0 ? "" : TextUtils.join((CharSequence)" ", (Object[])addressResult.getNames());
    }

    @Override
    public String getDisplaySubtitle() {
        return this.getResult().getOrg();
    }

    @Override
    public String getDisplayText() {
        return null;
    }

    @Override
    public int getDisplayIconRes() {
        return ThemesHelper.getResourceId((Context)this.getActivity(), 2130772045);
    }

    static {
        for (DateFormat format : DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH), new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.ENGLISH), new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH)}) {
            format.setLenient(false);
        }
        BUTTON_TEXTS = new int[]{2131165262, 2131165271, 2131165264, 2131165265};
    }
}

