package net.doo.snap.lib.ui;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;

import net.doo.snap.lib.PreferencesConstants;
import net.doo.snap.lib.billing.BillingConstants;
import net.doo.snap.lib.billing.BillingManager;
import net.doo.snap.lib.ui.themes.Theme;
import net.doo.snap.lib.ui.themes.ThemesProvider;

import roboguice.RoboGuice;
import roboguice.activity.RoboFragmentActivity;
import roboguice.inject.RoboInjector;

/**
 * Applies custom theme stored in preferences
 */
public class CustomThemeActivity extends RoboFragmentActivity {

    private ThemesProvider themesProvider;
    private BillingManager billingManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        themesProvider = initThemesProvider();
        billingManager = initBillingManager();

        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences(this);
        Theme theme = Theme.getThemeById(preferences.getInt(PreferencesConstants.CURRENT_THEME, Theme.SCANBOT.getId()));
        if (billingManager.isItemAvailable(BillingConstants.PRO_PACK_SKU) && theme != Theme.SCANBOT) {
            setTheme(themesProvider.getThemeResId(theme));
        } else {
            setTheme(themesProvider.getThemeResId(Theme.SCANBOT));
            preferences.edit().putInt(PreferencesConstants.CURRENT_THEME, Theme.SCANBOT.getId()).apply();
        }
        super.onCreate(savedInstanceState);
    }

    private BillingManager initBillingManager() {
        final RoboInjector injector = RoboGuice.getInjector(this);
        return injector.getProvider(BillingManager.class).get();
    }

    protected ThemesProvider initThemesProvider() {
        final RoboInjector injector = RoboGuice.getInjector(this);
        return injector.getProvider(ThemesProvider.class).get();
    }

}
