package net.doo.snap.lib.util.snap;

import android.content.Context;
import android.view.OrientationEventListener;

import com.google.inject.Inject;

import roboguice.event.EventManager;

/**
 * Listens for orientation changes and fires {@link ScreenRotationChangedEvent}
 * as soon as orientation change detected.
 */
public class OrientationHandler extends OrientationEventListener {

    private static final int[] ROTATION_DEGREES = {-180, -90, 0, 90};
    private static final int UPDATE_RATE_US = 200 * 1000;

    @Inject
    private EventManager eventManager;

    private int currentRotation = 0;

    @Inject
    public OrientationHandler(Context context) {
        super(context, UPDATE_RATE_US);
    }

    @Override
    public void onOrientationChanged(int rotation) {
        if (!canDetectOrientation() || rotation < 0) {
            return;
        }

        if (rotation > 180) {
            rotation -= 360;
        }

        final int newRotation = getClosestRotationDegree(rotation);

        if (newRotation != currentRotation) {
            eventManager.fire(new ScreenRotationChangedEvent(newRotation));
            currentRotation = newRotation;
        }
    }

    private int getClosestRotationDegree(int rotation) {
        for (int value : ROTATION_DEGREES) {
            final int diff = Math.abs(rotation - value);

            if (diff < 45) {
                return value;
            }
        }

        return currentRotation;
    }

}
