/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.edit;

import android.animation.Animator;
import android.app.Activity;
import android.view.View;
import android.view.ViewPropertyAnimator;
import com.google.inject.Inject;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.PageStoreStrategy;
import net.doo.snap.lib.snap.PreviewFragmentPagerAdapter;
import net.doo.snap.lib.snap.edit.EditLock;
import net.doo.snap.lib.snap.edit.PagesEditor;
import net.doo.snap.lib.snap.edit.events.DeletePageEvent;
import net.doo.snap.lib.snap.edit.util.PageEditorHelper;
import net.doo.snap.lib.snap.preview.ImagePreviewFragment;
import net.doo.snap.lib.ui.widget.ViewPager;
import net.doo.snap.lib.util.ui.UndoToast;
import net.doo.snap.lib.util.ui.ViewUtils;
import roboguice.event.Observes;

public class DeletePageEditor
implements PagesEditor,
UndoToast.OnUndoListener {
    private static final int SLIDE_DOWN_FACTOR = 10;
    private Activity activity;
    private EditLock editLock;
    private PageStoreStrategy strategy;
    private ViewPager pager;
    private PreviewFragmentPagerAdapter adapter;
    private PageEditorHelper editorHelper;
    private int lastDeletedItemPosition;
    private Page lastDeletedPage;

    @Inject
    public DeletePageEditor(Activity activity, EditLock editLock, PageStoreStrategy strategy) {
        this.activity = activity;
        this.editLock = editLock;
        this.strategy = strategy;
    }

    @Override
    public void attachViewPager(ViewPager viewPager, PreviewFragmentPagerAdapter adapter) {
        this.pager = viewPager;
        this.adapter = adapter;
        this.editorHelper = new PageEditorHelper(viewPager, adapter);
    }

    public void onPageDeletion(@Observes DeletePageEvent event) {
        if (this.editLock.isEditLocked()) {
            return;
        }
        int currentItem = this.pager.getCurrentItem();
        if (this.adapter.getPagesCount() == 0 || currentItem == this.adapter.getCount() - 1) {
            return;
        }
        this.buildDeletionAnimator(currentItem).start();
    }

    private ViewPropertyAnimator buildDeletionAnimator(final int itemToDelete) {
        final Page pageToDelete = this.adapter.getDocumentDraft().getPage(itemToDelete);
        return this.deletePageAnimator().setListener((Animator.AnimatorListener)new ViewUtils.DefaultAnimationListener(){

            @Override
            public void onAnimationStart(Animator animation) {
                DeletePageEditor.this.editLock.lockEdit();
            }

            @Override
            public void onAnimationFinished(Animator animation) {
                DeletePageEditor.this.lastDeletedPage = pageToDelete;
                DeletePageEditor.this.lastDeletedItemPosition = itemToDelete;
                if (DeletePageEditor.this.adapter.getPagesCount() > 1 && DeletePageEditor.this.pager.getCurrentItem() == itemToDelete) {
                    DeletePageEditor.this.editorHelper.deleteCurrentPage(new ViewUtils.DefaultAnimationListener(){

                        @Override
                        public void onAnimationFinished(Animator animation) {
                            DeletePageEditor.this.editLock.unlockEdit();
                            DeletePageEditor.this.showUndo();
                        }
                    });
                } else {
                    DeletePageEditor.this.adapter.deletePage(pageToDelete);
                    DeletePageEditor.this.editLock.unlockEdit();
                    DeletePageEditor.this.showUndo();
                }
            }
        });
    }

    private ViewPropertyAnimator deletePageAnimator() {
        ImagePreviewFragment fragment = this.adapter.getFragment(this.pager, this.pager.getCurrentItem());
        View view = fragment.getView();
        return view.animate().alpha(0.0f).translationYBy((float)(this.pager.getHeight() / 10));
    }

    private void showUndo() {
        new UndoToast(this.activity).listener(this).message(2131165259).duration(3000).show();
    }

    @Override
    public void onUndo() {
        this.editorHelper.addPageToPosition(this.lastDeletedPage, this.lastDeletedItemPosition, new ViewUtils.DefaultAnimationListener(){

            @Override
            public void onAnimationStart(Animator animator2) {
                DeletePageEditor.this.editLock.lockEdit();
            }

            @Override
            public void onAnimationFinished(Animator animator2) {
                DeletePageEditor.this.lastDeletedPage = null;
                DeletePageEditor.this.editLock.unlockEdit();
            }
        });
    }
}

