package net.doo.snap.lib.smartname;

import net.doo.snap.lib.R;

/**
 * Represents all types of smart name terms
 */
public enum TermType {

    CITY(0, R.string.term_name_city),
    YEAR(1, R.string.term_name_year),
    YEAR_SHORT(2, R.string.term_name_year_short),
    MONTH(3, R.string.term_name_month),
    DAY(4, R.string.term_name_day),
    HOURS(5, R.string.term_name_hours),
    MINUTES(6, R.string.term_name_minutes),
    SECONDS(7, R.string.term_name_seconds),
    DEVICE_MODEL(8, R.string.term_name_device_model);

    private final int id;
    private final int displayNameResId;

    TermType(int id, int displayNameResId) {
        this.id = id;
        this.displayNameResId = displayNameResId;
    }

    /**
     * @return display name resource id
     */
    public int getDisplayNameResId() {
        return displayNameResId;
    }

    /**
     * @return database id
     */
    public int getId() {
        return id;
    }

    /**
     * @param id
     * @return {@link net.doo.snap.lib.smartname.TermType} by database id
     */
    public static TermType getTermTypeById(int id) {
        for (TermType termType : values()) {
            if (termType.getId() == id) {
                return termType;
            }
        }
        return CITY;
    }
}
