/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.hardware.Camera;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.CameraView;

public class PictureTransaction
implements Camera.ShutterCallback {
    CameraHost host = null;
    boolean needBitmap = false;
    boolean needByteArray = true;
    private Object tag = null;
    boolean mirrorFFC = false;
    boolean useSingleShotMode = false;
    int displayOrientation = 0;
    String flashMode = null;
    CameraView cameraView = null;

    public PictureTransaction(CameraHost host) {
        this.host = host;
    }

    public PictureTransaction needBitmap(boolean needBitmap) {
        this.needBitmap = needBitmap;
        return this;
    }

    public PictureTransaction needByteArray(boolean needByteArray) {
        this.needByteArray = needByteArray;
        return this;
    }

    public Object getTag() {
        return this.tag;
    }

    public PictureTransaction tag(Object tag) {
        this.tag = tag;
        return this;
    }

    boolean useSingleShotMode() {
        return this.useSingleShotMode || this.host.useSingleShotMode();
    }

    boolean mirrorFFC() {
        return this.mirrorFFC || this.host.mirrorFFC();
    }

    public PictureTransaction useSingleShotMode(boolean useSingleShotMode) {
        this.useSingleShotMode = useSingleShotMode;
        return this;
    }

    public PictureTransaction mirrorFFC(boolean mirrorFFC) {
        this.mirrorFFC = mirrorFFC;
        return this;
    }

    public PictureTransaction flashMode(String flashMode) {
        this.flashMode = flashMode;
        return this;
    }

    PictureTransaction displayOrientation(int displayOrientation) {
        this.displayOrientation = displayOrientation;
        return this;
    }

    public void onShutter() {
        Camera.ShutterCallback cb = this.host.getShutterCallback();
        if (cb != null) {
            cb.onShutter();
        }
    }
}

