package net.doo.snap.lib.persistence;

import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;

/**
 * implements Parcelable {@link net.doo.snap.lib.persistence.Page} text annotation
 */
public class Annotation implements Parcelable {

    private String id;
    private String content;
    private final PointF position;

    public Annotation() {
        position = new PointF();
    }

    protected Annotation(Parcel in) {
        id = in.readString();
        content = in.readString();
        position = (PointF) in.readValue(PointF.class.getClassLoader());
    }

    /**
     * @return unique identifier of annotation
     */
    public String getId() {
        return id;
    }

    /**
     * @param id unique identifier of annotation
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @return text content of annotation
     */
    public String getContent() {
        return content;
    }

    /**
     * @param content text content of annotation
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * @return mutable position of this {@link net.doo.snap.lib.persistence.Annotation} on page in
     * normalized form (values are between 0.0 and 1.0).
     */
    public PointF getPosition() {
        return position;
    }

    /**
     * @param position position of this {@link net.doo.snap.lib.persistence.Annotation} on page in
     *                 normalized form (values are between 0.0 and 1.0).
     */
    public void setPosition(PointF position) {
        this.position.set(position);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Annotation)) return false;

        Annotation that = (Annotation) o;

        return id.equals(that.id);

    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(id);
        dest.writeString(content);
        dest.writeValue(position);
    }

    @SuppressWarnings("unused")
    public static final Parcelable.Creator<Annotation> CREATOR = new Parcelable.Creator<Annotation>() {
        @Override
        public Annotation createFromParcel(Parcel in) {
            return new Annotation(in);
        }

        @Override
        public Annotation[] newArray(int size) {
            return new Annotation[size];
        }
    };
}