package net.doo.snap.lib.ui.widget.text;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.text.TextPaint;
import android.util.AttributeSet;

import net.doo.snap.lib.R;

/**
 * Lets you specify text circle radius in XML
 */
@SuppressWarnings("unused")
public class CircularTextView extends CustomTypefaceTextView {

    public static final double THREE_FORTH_CIRCLE_INDEX = 1.5;
    private final float radius;

    public CircularTextView(Context context) {
        super(context);
        radius = 0;
    }

    public CircularTextView(Context context, AttributeSet attrs) {
        super(context, attrs);

        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircularTextView);
        radius = a.getDimensionPixelSize(R.styleable.CircularTextView_text_radius, 0);
    }

    public CircularTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);

        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircularTextView);
        radius = a.getDimensionPixelSize(R.styleable.CircularTextView_text_radius, 0);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        TextPaint paint = getPaint();
        paint.setColor(getCurrentTextColor());
        paint.drawableState = getDrawableState();

        Path path = new Path();
        path.addCircle(getWidth() / 2, getHeight() / 2 + radius, radius, Path.Direction.CW);
        float textWidth = paint.measureText(getText().toString());
        double offset = Math.PI * radius * THREE_FORTH_CIRCLE_INDEX - textWidth / 2;
        canvas.drawTextOnPath(getText().toString(), path, (float) offset, 0, paint);
    }

}
