/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.sensor;

import net.doo.snap.lib.sensor.SignificantMoveListener;

public abstract class ShakeListener
implements SignificantMoveListener {
    private static final int MAX_SHAKE_TIME_MS = 2000;
    private static final int NEXT_SHAKE_DELAY_MS = 3000;
    private static final int SHAKE_MOVES_COUNT = 6;
    private int movesCount;
    private long lastMove;
    private long lastShake;

    @Override
    public float getSignificantMoveThreshold() {
        return 5.0f;
    }

    @Override
    public void onSignificantMove() {
        long currentMove = System.currentTimeMillis();
        this.movesCount = currentMove - this.lastMove > 2000L ? 1 : ++this.movesCount;
        if (this.movesCount >= 6 && currentMove - this.lastShake > 3000L) {
            this.movesCount = 0;
            this.lastShake = currentMove;
            this.onShake();
        }
        this.lastMove = currentMove;
    }

    public abstract void onShake();
}

