/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.persistence;

import android.graphics.Bitmap;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.PageStoreStrategy;
import net.doo.snap.lib.util.bitmap.BitmapLruCache;
import net.doo.snap.lib.util.bitmap.BitmapUtils;
import net.doo.snap.lib.util.log.DebugLog;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PageFactory {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    @Inject
    private BitmapLruCache bitmapLruCache;
    private PageStoreStrategy pageStoreStrategy;

    @Inject
    public PageFactory(PageStoreStrategy pageStoreStrategy) {
        this.pageStoreStrategy = pageStoreStrategy;
    }

    public Result buildPage(byte[] image, int screenWidth, int screenHeight) throws IOException {
        Page page = new Page();
        File pageDir = this.pageStoreStrategy.getPageDir(page.getId());
        FileUtils.forceMkdir((File)pageDir);
        File filteredDir = FileUtils.getFile((File)pageDir, (String[])new String[]{"filtered"});
        FileUtils.forceMkdir((File)filteredDir);
        FileUtils.writeByteArrayToFile((File)new File(pageDir, Page.ImageType.ORGINAL.getFileName()), (byte[])image);
        final Bitmap preview = BitmapUtils.createPreview(image, screenWidth, screenHeight);
        page.setImageSize(Page.ImageType.OPTIMIZED_PREVIEW, preview.getWidth(), preview.getHeight());
        final String previewPath = this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.PREVIEW).getPath();
        this.bitmapLruCache.put(previewPath, preview);
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(previewPath);
                    preview.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out);
                }
                catch (IOException e) {
                    try {
                        DebugLog.logException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        });
        return new Result(page, preview);
    }

    public static class Result {
        public final Page page;
        public final Bitmap preview;

        public Result(Page page, Bitmap preview) {
            this.page = page;
            this.preview = preview;
        }
    }
}

