package net.doo.snap.lib.billing;

/**
 * Represents a functionality of the app managed by {@link net.doo.snap.lib.billing.BillingManager}.
 *
 * @see net.doo.snap.lib.billing.BillingManager
 * @see net.doo.snap.lib.billing.FeatureExecutor
 */
public abstract class Feature {

    private final BillingContent billingContent;

    public Feature(BillingContent billingContent) {
        this.billingContent = billingContent;
    }

    /**
     * @return billing content of app's feature
     */
    public BillingContent getBillingContent() {
        return billingContent;
    }

    /**
     * Implementation of feature itself.
     */
    protected abstract void run();

}
