/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera.barcode;

import com.google.inject.Inject;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class BarcodeDetector {
    private static final int BARCODE_SCANNING_INTERVAL_SEC = 7;
    private final MultiFormatReader multiFormatReader;
    private Result lastResult;
    private AtomicBoolean barcodeScanEnabled = new AtomicBoolean(true);
    private ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> schedule;

    @Inject
    public BarcodeDetector() {
        this.multiFormatReader = new MultiFormatReader();
    }

    public void enableBarcodeScan(boolean barcodeScanEnabled) {
        if (this.schedule != null && !this.schedule.isDone()) {
            if (!barcodeScanEnabled) {
                this.schedule.cancel(false);
            }
        } else {
            this.barcodeScanEnabled.set(barcodeScanEnabled);
        }
    }

    public Result getLastResult() {
        return this.lastResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result decodeWithState(byte[] data, int width, int height) {
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        try {
            PlanarYUVLuminanceSource source = new PlanarYUVLuminanceSource(data, width, height, 0, 0, width, height, false);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            this.lastResult = this.multiFormatReader.decodeWithState(bitmap);
            if (this.lastResult != null) {
                this.barcodeScanEnabled.set(false);
            }
            Result result = this.lastResult;
            return result;
        }
        catch (ReaderException re) {
        }
        finally {
            this.multiFormatReader.reset();
        }
        return null;
    }

    public void resetBarcodeDetectionTimer() {
        this.schedule = this.scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                BarcodeDetector.this.barcodeScanEnabled.set(true);
            }
        }, 7L, TimeUnit.SECONDS);
    }
}

