/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util.log;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DebugLog {
    public static final String LOG_DIRECTORY = "debug_logs";
    public static final String LOG_EXTENSION = ".txt";
    private static final String LOG_FIELD_SEPARATOR = " | ";
    private static final String UNKNOWN_SIGNATURE = "[unknown]";
    private static final String DEFAULT_PACKAGE_NAME = "default";
    private static final String NO_APPLICATION_INFO_MESSAGE = "[No application info]";
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss.SSS] ");
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("([A-Z]*|(^[a-z]))[_\\da-z\\$]*");
    private static boolean prepared = false;
    private static boolean savingEnabled = true;
    private static boolean echoEnabled = true;
    private static Level savingLevel = Level.Verbose;
    private static Level echoLevel = Level.Verbose;
    private static String packageName = "default";

    private DebugLog() {
    }

    public static synchronized void prepare(Context context) {
        prepared = true;
        if (context != null) {
            packageName = context.getPackageName();
            DebugLog.printVersionInfo(context);
        } else {
            packageName = DEFAULT_PACKAGE_NAME;
        }
    }

    private static void printVersionInfo(Context context) {
        String message;
        PackageManager packageMgr = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageMgr.getPackageInfo(packageName, 0);
            int appLabelId = packageInfo.applicationInfo.labelRes;
            message = (appLabelId != 0 ? context.getString(appLabelId) : UNKNOWN_SIGNATURE) + " v" + packageInfo.versionName + " #" + packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            DebugLog.logException(e);
            message = NO_APPLICATION_INFO_MESSAGE;
        }
        DebugLog.i("APP_INFO", message);
    }

    public static void d(String tag, String message) {
        DebugLog.logMessage(tag, message, Level.Debug);
    }

    public static void w(String tag, String message) {
        DebugLog.logMessage(tag, message, Level.Warning);
    }

    public static void e(String tag, String message) {
        DebugLog.logMessage(tag, message, Level.Error);
    }

    public static void i(String tag, String message) {
        DebugLog.logMessage(tag, message, Level.Information);
    }

    public static void e(String tag, String where, Throwable e) {
        String message = "Exception in " + where + ": " + e.getClass().getName() + LOG_FIELD_SEPARATOR + e.getMessage();
        DebugLog.e(tag, message);
    }

    public static void d(String message) {
        String tag = DebugLog.getCallerClassName();
        DebugLog.d(tag, message);
    }

    public static void i(String message) {
        String tag = DebugLog.getCallerClassName();
        DebugLog.i(tag, message);
    }

    public static void w(String message) {
        String tag = DebugLog.getCallerClassName();
        DebugLog.w(tag, message);
    }

    public static void e(String message) {
        String tag = DebugLog.getCallerClassName();
        DebugLog.e(tag, message);
    }

    public static void logException(Throwable e) {
        String tag = DebugLog.getCallerClassName();
        String where = DebugLog.getCallerMethodName();
        if (e != null) {
            DebugLog.e(tag, where, e);
        } else {
            DebugLog.e(tag, where, new Exception("Unknown exception"));
        }
    }

    public static void logExceptionWithStackTrace(Throwable e) {
        String tag = DebugLog.getCallerClassName();
        if (e != null) {
            String exceptionStackTrace = Log.getStackTraceString((Throwable)e);
            DebugLog.e(tag, exceptionStackTrace);
        } else {
            DebugLog.e(tag, "", new Exception("Unknown exception"));
        }
    }

    public static void logMethod() {
        String tag = DebugLog.getCallerClassName();
        String where = DebugLog.getCallerMethodName();
        DebugLog.i(tag, where);
    }

    public static boolean isSavingEnabled() {
        return savingEnabled;
    }

    public static synchronized void setSavingEnabled(boolean enabled) {
        savingEnabled = enabled;
    }

    public static boolean isEchoEnabled() {
        return echoEnabled;
    }

    public static void setEchoEnabled(boolean echoEnabled) {
        DebugLog.echoEnabled = echoEnabled;
    }

    public static Level getLevel() {
        return savingLevel;
    }

    public static void setLevel(Level level) {
        if (level != null) {
            savingLevel = level;
        }
    }

    public static Level getEchoLevel() {
        return echoLevel;
    }

    public static void setEchoLevel(Level echoLevel) {
        if (echoLevel != null) {
            DebugLog.echoLevel = echoLevel;
        }
    }

    public static void logStackTrace() {
        String tag = DebugLog.getCallerClassName();
        DebugLog.i(tag, "print stack trace");
        DebugLog.i(tag, "-----------------");
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int callertStackIndex = 3;
        StringBuilder sb = new StringBuilder();
        for (int i = 3; i < trace.length; ++i) {
            StackTraceElement stackTraceElement = trace[i];
            sb.append("at ");
            sb.append(stackTraceElement.getClassName());
            sb.append('.');
            sb.append(stackTraceElement.getMethodName());
            sb.append('(');
            if (stackTraceElement.isNativeMethod()) {
                sb.append("Native Method");
            } else {
                sb.append(stackTraceElement.getFileName());
                sb.append(':');
                sb.append(stackTraceElement.getLineNumber());
            }
            sb.append(")\n");
        }
        DebugLog.i(tag, sb.toString());
        DebugLog.i(tag, "-----------------");
    }

    private static void logMessage(String tag, String message, Level level) {
        if (!prepared) {
            return;
        }
        if (echoEnabled && level.ordinal() >= echoLevel.ordinal()) {
            DebugLog.echoMessage(tag, message, level);
        }
        if (savingEnabled && level.ordinal() >= savingLevel.ordinal()) {
            DebugLog.logToFile(tag, message, level);
        }
    }

    private static void echoMessage(String tag, String message, Level level) {
        switch (level) {
            case Debug: {
                Log.d((String)tag, (String)message);
                break;
            }
            case Error: {
                Log.e((String)tag, (String)message);
                break;
            }
            case Warning: {
                Log.w((String)tag, (String)message);
                break;
            }
            case Information: {
                Log.i((String)tag, (String)message);
                break;
            }
            case Verbose: {
                Log.v((String)tag, (String)message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void logToFile(String tag, String message, Level level) {
        Writer writer = DebugLog.getLogWriter();
        if (writer != null) {
            try {
                writer.write(DebugLog.buildLogMessage(tag, message, level));
            }
            catch (IOException e) {
            }
            finally {
                DebugLog.closeSafely(writer);
            }
        }
    }

    private static void closeSafely(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String buildLogMessage(String tag, String message, Level level) {
        String editedTag = tag != null ? tag.replace('|', '/') : "";
        return TIME_FORMAT.format(new Date()) + (Object)((Object)level) + LOG_FIELD_SEPARATOR + editedTag + LOG_FIELD_SEPARATOR + message + "\r\n";
    }

    private static Writer getLogWriter() {
        FileWriter writer = null;
        File externalStorage = Environment.getExternalStorageDirectory();
        DebugLog.prepareLogsFolder(externalStorage);
        File logfile = new File(externalStorage, DebugLog.getLogFilename());
        try {
            writer = new FileWriter(logfile, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer;
    }

    private static void prepareLogsFolder(File externalStorage) {
        File logDir = new File(externalStorage, LOG_DIRECTORY);
        if (!logDir.exists()) {
            logDir.mkdir();
        }
    }

    private static String getLogFilename() {
        return LOG_DIRECTORY + File.separatorChar + packageName + LOG_EXTENSION;
    }

    private static String tokenizeClassName(String className) {
        String result;
        ArrayList<String> parts = new ArrayList<String>();
        try {
            Matcher matcher = CLASS_NAME_PATTERN.matcher(className);
            while (matcher.find()) {
                String part = className.substring(matcher.start(), matcher.end());
                if (TextUtils.isEmpty((CharSequence)part.trim())) continue;
                parts.add(part.toUpperCase());
            }
            result = parts.isEmpty() ? className : TextUtils.join((CharSequence)"_", parts);
        }
        catch (Exception e) {
            result = className;
        }
        return result;
    }

    private static String getCallerClassName() {
        String className;
        int CALLER_STACK_INDEX = 4;
        try {
            String fullClassName;
            int lastPoint;
            StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
            className = callStack.length > 4 ? ((lastPoint = (fullClassName = callStack[4].getClassName()).lastIndexOf(".")) >= 0 && lastPoint + 1 < fullClassName.length() ? fullClassName.substring(lastPoint + 1) : UNKNOWN_SIGNATURE) : UNKNOWN_SIGNATURE;
        }
        catch (Exception e) {
            className = UNKNOWN_SIGNATURE;
        }
        return DebugLog.tokenizeClassName(className);
    }

    private static String getCallerMethodName() {
        String methodName;
        int CALLER_STACK_INDEX = 4;
        try {
            StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
            methodName = callStack.length > 4 ? callStack[4].getMethodName() : UNKNOWN_SIGNATURE;
        }
        catch (Exception e) {
            methodName = UNKNOWN_SIGNATURE;
        }
        return methodName;
    }

    private static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static enum Level {
        Verbose("V"),
        Debug("D"),
        Information("I"),
        Warning("W"),
        Error("E");

        private final String label;

        private Level(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

