package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;

import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.SMSParsedResult;

import net.doo.snap.lib.R;
import net.doo.snap.lib.util.ThemesHelper;

/**
 * Handles SMS addresses, offering a choice of composing a new SMS or MMS message.
 */
public final class SMSResultHandler extends ResultHandler {
    private static final int[] buttons = {
            R.string.button_sms,
            R.string.button_mms
    };
    private static final int SEND_SMS = 0;
    private static final int SEND_MMS = 1;

    public SMSResultHandler(Activity activity, SMSParsedResult result) {
        super(activity, result);
    }

    @Override
    public SMSParsedResult getResult() {
        return (SMSParsedResult) super.getResult();
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        SMSParsedResult smsResult = getResult();
        String number = smsResult.getNumbers()[0];
        switch (index) {
            case SEND_SMS:
                // Don't know of a way yet to express a SENDTO intent with multiple recipients
                sendSMS(number, smsResult.getBody());
                break;
            case SEND_MMS:
                sendMMS(number, smsResult.getSubject(), smsResult.getBody());
                break;
        }
    }

    @Override
    public CharSequence getDisplayContents() {
        SMSParsedResult smsResult = getResult();
        String[] rawNumbers = smsResult.getNumbers();
        String[] formattedNumbers = new String[rawNumbers.length];
        for (int i = 0; i < rawNumbers.length; i++) {
            formattedNumbers[i] = PhoneNumberUtils.formatNumber(rawNumbers[i]);
        }
        StringBuilder contents = new StringBuilder(50);
        ParsedResult.maybeAppend(formattedNumbers, contents);
        ParsedResult.maybeAppend(smsResult.getSubject(), contents);
        ParsedResult.maybeAppend(smsResult.getBody(), contents);
        return contents.toString();
    }

    @Override
    public String getDisplayTitle() {
        return getActivity().getString(R.string.qr_code_sms_title);
    }

    @Override
    public String getDisplaySubtitle() {
        return TextUtils.join(" ", getResult().getNumbers());
    }

    @Override
    public String getDisplayText() {
        return getResult().getBody();
    }

    @Override
    public int getDisplayIconRes() {
        return ThemesHelper.getResourceId(getActivity(), R.attr.ui_qr_ico_sms);
    }
}
