package net.doo.snap.lib;

/**
 * Contains keys, that are used in {@link android.content.SharedPreferences}
 */
public interface PreferencesConstants {

    String SNAP_LIB_PREFIX = "SNAP_LIB_";

    String SKU_PRICE_PREFIX = "PRICE_";

    String SKU_DEVELOPER_PAYLOAD_PREFIX = "NONCE_";

    /**
     * Contains flag whether {@link net.doo.snap.lib.ui.tutorial.CameraTutorialFragment} was shown or not
     */
    String CAMERA_TUTORIAL = SNAP_LIB_PREFIX + "CAMERA_TUTORIAL";

    /**
     * Contains flag whether {@link net.doo.snap.lib.ui.tutorial.AddNewPageTutorialFragment} was shown or not
     */
    String ADD_NEW_PAGE_TUTORIAL = SNAP_LIB_PREFIX + "ADD_NEW_PAGE_TUTORIAL";

    /**
     * Contains flag whether {@link net.doo.snap.lib.ui.tutorial.RearrangementTutorialFragment} was shown or not
     */
    String REARRANGEMENT_TUTORIAL = SNAP_LIB_PREFIX + "REARRANGEMENT_TUTORIAL";

    /**
     * Contains last used filter
     */
    String LAST_USED_FILTER = "LAST_USED_FILTER";

    /**
     * Width of snapped picture
     */
    String DEVEL_PICTURE_WIDTH = "DEVEL_PICTURE_WIDTH";

    /**
     * Height of snapped picture
     */
    String DEVEL_PICTURE_HEIGHT = "DEVEL_PICTURE_HEIGHT";

    /**
     * {@code true} if barcode scanner should be enabled, {@code false} otherwise
     */
    String SCAN_BARCODES = "SCAN_BARCODES";

    /**
     * {@code true} if autosnapping is enabled, {@code false} otherwise
     */
    String AUTOSNAP = "AUTOSNAP";

    /**
     * Contains smart name template
     */
    String SMART_NAME_TEMPLATE = "SMART_NAME_TEMPLATE";

    /**
     * Contains smart name terms types
     */
    String SMART_NAME_TERMS_TYPES = "SMART_NAME_TERMS_TYPES";

    /**
     * Contains smart name example
     */
    String SMART_NAME_EXAMPLE = "SMART_NAME_EXAMPLE";

    /**
     * Contains current theme resource id
     */
    String CURRENT_THEME = "CURRENT_THEME";

    /**
     * Last snap exposure time
     */
    String LAST_EXPOSURE_TIME = "LAST_EXPOSURE_TIME";

    /**
     * Last snap exposure correction
     */
    String LAST_EXPOSURE_COMPENSATION = "LAST_EXPOSURE_COMPENSATION";
}
