package net.doo.snap.lib.snap.camera.debug;

import android.content.Context;
import android.content.SharedPreferences;
import android.hardware.Camera;

import com.commonsware.cwac.camera.PictureTransaction;
import com.google.inject.Inject;

import net.doo.snap.lib.PreferencesConstants;
import net.doo.snap.lib.snap.camera.SnapCameraHost;
import net.doo.snap.lib.util.snap.Utils;

/**
 * {@link net.doo.snap.lib.snap.camera.SnapCameraHost} which accepts custom camera preferences:
 * - {@link net.doo.snap.lib.PreferencesConstants#DEVEL_PICTURE_WIDTH}
 * - {@link net.doo.snap.lib.PreferencesConstants#DEVEL_PICTURE_HEIGHT}
 */
public class DebugCameraHost extends SnapCameraHost {

    @Inject
    private SharedPreferences preferences;

    @Inject
    public DebugCameraHost(Context context) {
        super(context);
    }

    @Override
    public Camera.Size getPictureSize(PictureTransaction xact, Camera.Parameters parameters) {
        if (preferences.contains(PreferencesConstants.DEVEL_PICTURE_WIDTH) && preferences.contains(PreferencesConstants.DEVEL_PICTURE_HEIGHT)) {
            Camera.Size size = Utils.findByWidthAndHeight(
                    parameters,
                    preferences.getInt(PreferencesConstants.DEVEL_PICTURE_WIDTH, 0),
                    preferences.getInt(PreferencesConstants.DEVEL_PICTURE_HEIGHT, 0)
            );

            if (size != null) {
                return size;
            }
        }

        return super.getPictureSize(xact, parameters);
    }
}
