package net.doo.snap.lib.util.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.DisplayMetrics;

/**
 * Loads bitmaps scaled to screen size
 */
public class ScaledPageBitmapLoader extends PageBitmapLoader {
    private DisplayMetrics displayMetrics;

    public ScaledPageBitmapLoader(Context context, String imagePath, BitmapLruCache bitmapLruCache, Bitmap preservedBitmap) {
        super(context, imagePath, bitmapLruCache, preservedBitmap);

        displayMetrics = context.getResources().getDisplayMetrics();
    }

    @Override
    public Bitmap loadInBackground() {
        if (imagePath != null) {
            final BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapUtils.decodeQuietly(imagePath, options);
            options.inSampleSize = BitmapUtils.calculateInSampleSize(options, displayMetrics.widthPixels, displayMetrics.heightPixels);
            options.inJustDecodeBounds = false;
            return BitmapUtils.decodeQuietly(imagePath, options);
        }
        return null;
    }
}
