/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.billing;

import android.content.SharedPreferences;
import com.google.inject.Inject;
import net.doo.snap.lib.util.OperatorDetector;
import roboguice.event.EventManager;

public class LocalItemsManager {
    @Inject
    private SharedPreferences preferences;
    @Inject
    private OperatorDetector operatorDetector;
    @Inject
    private EventManager eventManager;

    @Inject
    public LocalItemsManager() {
    }

    public void initializeLocalItems() {
        boolean isTelekomCustomer = this.operatorDetector.getNetworkOperator().equals((Object)OperatorDetector.NetworkOperator.TELEKOM);
        long endOfTelekomPromo = this.preferences.getLong("PRO_PACK_OFFLINE_TELEKOM_END", 0L);
        boolean isActivatedTelekomCustomer = this.preferences.contains("pro_pack_trial_telekom_local");
        if (isActivatedTelekomCustomer) {
            boolean prevState = this.preferences.getBoolean("pro_pack_trial_telekom_local", false);
            SharedPreferences.Editor editor = this.preferences.edit();
            boolean keepTelekomTrial = isTelekomCustomer && System.currentTimeMillis() < endOfTelekomPromo;
            editor.putBoolean("pro_pack_trial_telekom_local", keepTelekomTrial);
            if (!keepTelekomTrial && prevState) {
                editor.putBoolean("SHOW_TELEKOM_DISCOUNT_DIALOG", true);
            }
            editor.apply();
        }
    }

    public boolean isItemExpired(String sku) {
        switch (sku) {
            case "pro_pack_trial_telekom_local": {
                return this.preferences.contains(sku) && this.preferences.getBoolean(sku, false);
            }
        }
        return false;
    }
}

