package net.doo.snap.lib.persistence;

import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;

/**
 * Represents a digital signature for the user physical signature
 *
 * @see net.doo.snap.lib.persistence.Page
 */
public class Signature implements Parcelable {
    private String id;
    private RectF rect = new RectF();
    private String imagePath;

    /**
     * @return signature unique id
     */
    public String getId() {
        return id;
    }

    /**
     * sets signature id
     *
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     *
     * @return Mutable Rectangle containing signature
     */
    public RectF getRect() {
        return rect;
    }

    /**
     * Sets bounds for signature
     * @param rect
     */
    public void setRect(RectF rect) {
        this.rect = rect;
    }

    /**
     * @return path to the image of this {@link net.doo.snap.lib.persistence.Signature}. Default is {@code null}.
     */
    public String getImagePath() {
        return imagePath;
    }

    /**
     * @param imagePath path to the image of this {@link net.doo.snap.lib.persistence.Signature}. Can be {@code null}.
     */
    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Signature)) return false;
        return id.equals(((Signature) o).id);
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeParcelable(this.rect, 0);
        dest.writeString(this.imagePath);
    }

    public Signature() {
    }

    private Signature(Parcel in) {
        this.id = in.readString();
        this.rect = in.readParcelable(RectF.class.getClassLoader());
        this.imagePath = in.readString();
    }

    public static Parcelable.Creator<Signature> CREATOR = new Parcelable.Creator<Signature>() {
        public Signature createFromParcel(Parcel source) {
            return new Signature(source);
        }

        public Signature[] newArray(int size) {
            return new Signature[size];
        }
    };
}
