package net.doo.snap.lib.billing;

import android.content.SharedPreferences;

import com.google.inject.Inject;

import net.doo.snap.lib.PreferencesConstants;
import net.doo.snap.lib.util.OperatorDetector;

import roboguice.event.EventManager;

/**
 * Initializes local sku items
 */
public class LocalItemsManager {

    @Inject
    private SharedPreferences preferences;
    @Inject
    private OperatorDetector operatorDetector;
    @Inject
    private EventManager eventManager;

    @Inject
    public LocalItemsManager() {
    }

    /**
     * Init all local items
     */
    public void initializeLocalItems() {
        boolean isTelekomCustomer = operatorDetector.getNetworkOperator().equals(OperatorDetector.NetworkOperator.TELEKOM);
        long endOfTelekomPromo = preferences.getLong(PreferencesConstants.PRO_PACK_OFFLINE_TELEKOM_END, 0);
        boolean isActivatedTelekomCustomer = preferences.contains(BillingConstants.PRO_PACK_TRIAL_TELEKOM_SKU_LOCAL);

        if (isActivatedTelekomCustomer) {
            boolean prevState = preferences.getBoolean(BillingConstants.PRO_PACK_TRIAL_TELEKOM_SKU_LOCAL, false);
            SharedPreferences.Editor editor = preferences.edit();
            boolean keepTelekomTrial = isTelekomCustomer && System.currentTimeMillis() < endOfTelekomPromo;
            editor.putBoolean(BillingConstants.PRO_PACK_TRIAL_TELEKOM_SKU_LOCAL, keepTelekomTrial);
            if (!keepTelekomTrial && prevState) {
                editor.putBoolean(PreferencesConstants.SHOW_TELEKOM_DISCOUNT_DIALOG, true);
            }
            editor.apply();
        }
    }

    /**
     * @param sku
     * @return {@code true} if item expired, {@code false} - otherwise
     */
    public boolean isItemExpired(String sku) {
        switch (sku) {
            case BillingConstants.PRO_PACK_TRIAL_TELEKOM_SKU_LOCAL:
                return preferences.contains(sku) && !preferences.getBoolean(sku, false);
        }
        return false;
    }
}
